package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import java.io.Serializable;
import java.util.Date;

/**
 * 车场表 实体类
 */
@Data
@TableName("ice_park")
public class Park implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 车场id
     */
    @TableField("park_id")
    private Long parkId;
    /**
     * 车场类型 1-场库，2-路内
     */
    @TableField("park_type")
    private Integer parkType;
    /**
     * 车场编号
     */
    @TableField("park_code")
    private String parkCode;
    /**
     * 车场名称
     */
    @TableField("park_name")
    private String parkName;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;
}