package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;

import java.io.Serializable;


/**
 *  实体类
 */
@Data
@TableName("ice_order_notpay")
public class OrderNotPay implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 订单号
     */
    @TableField("order_num")
    private String orderNum;
    /**
     * 车牌号
     */
    @TableField("plate_num")
    private String plateNum;
    /**
     * 车牌颜色
     */
    @TableField("plate_color")
    private String plateColor;
    /**
     * 进场时间
     */
    @TableField("enter_time")
    private Integer enterTime;
    /**
     * 离场时间
     */
    @TableField("exit_time")
    private Integer exitTime;
    /**
     * 1-场库，2-路内
     */
    @TableField("park_type")
    private Integer parkType;
    /**
     * 车场ID
     */
    @TableField("park_id")
    private Integer parkId;
    /**
     * 支付状态
     * 场库 1未补缴、2已补缴、3已删除
     * 路内 1：未缴费2：预交费中，3：欠费，4：已缴费，5：无需缴费，6：未知
     */
    @TableField("pay_status")
    private Integer payStatus;
}