package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import lombok.Data;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 商户充值记录 实体类
 */
@Data
@TableName("ice_merchant_recharge")
public class MerchantRecharge implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 商户id
     */
    @TableField("merchant_id")
    private Long merchantId;
    /**
     * 充值金额
     */
    @TableField("recharge_price")
    private BigDecimal rechargePrice;
    /**
     * 实付金额
     */
    @TableField("pay_price")
    private BigDecimal payPrice;
    /**
     * 支付状态:0未支付;1已支付
     */
    @TableField("pay_status")
    private Integer payStatus;
    /**
     * 余额
     */
    @TableField("balance")
    private BigDecimal balance;
    /**
     * 备注
     */
    @TableField("remark")
    private String remark;
    /**
     * 创建时间
     */
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;
    /**
     * 更新时间
     */
    @TableField(value = "update_time", fill = FieldFill.INSERT_UPDATE)
    private Date updateTime;
    /**
     * 操作人
     */
    @TableField("operator")
    private String operator;
    /**
     * 删除标识:0未删除;1已删除
     */
    @TableField("deleted")
    private Integer deleted;
}