package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;

/**
 * 优惠券发放记录 实体类
 */
@Data
@Accessors(chain = true)
@TableName("ice_coupon_grant_record")
public class CouponGrantRecord implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 商户ID
     */
    @TableField("merchant_id")
    private Long merchantId;
    /**
     * 优惠券ID
     */
    @TableField("coupon_id")
    private Long couponId;
    /**
     * 优惠券领取编号
     */
    @TableField("grant_no")
    private String grantNo;
    /**
     * 优惠券使用起始日期
     */
    @TableField("start_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date startTime;
    /**
     * 优惠券使用截至日期
     */
    @TableField("end_time")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date endTime;
    /**
     * 小程序OpenId
     */
    @TableField("open_id")
    private String openId;
    /**
     * 手机号
     */
    @TableField("phone")
    private String phone;
    /**
     * 静态码编号
     */
    @TableField("qr_code_num")
    private String qrCodeNum;
    /**
     * 发放方式 1-静态码，2-动态码
     */
    @TableField("grant_type")
    private Integer grantType;
    /**
     * 优惠券使用状态 0-未使用， 1-已使用
     */
    @TableField("use_state")
    private Integer useState;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;

    public static final Integer USE_STATE_UNUSED = 0;
    public static final Integer USE_STATE_USED = 1;
}