package com.icetech.city.common.domain.entity.common;

import com.baomidou.mybatisplus.annotation.*;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import java.io.Serializable;
import java.util.Date;

/**
 * 静态码下载表 实体类
 */
@Data
@TableName("ice_coupon_download")
public class CouponDownload implements Serializable {
    /**
     * 主键ID
     */
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;
    /**
     * 商户ID
     */
    @TableField("merchant_id")
    private Long merchantId;
    /**
     * 优惠券ID
     */
    @TableField("coupon_id")
    private Long couponId;
    /**
     * 静态码编号
     */
    @TableField("qr_code_num")
    private String qrCodeNum;
    /**
     * 扫码限制次数
     */
    @TableField("scan_count")
    private Integer scanCount;
    /**
     * 静态码扫码次数
     */
    @TableField("qr_code_scan")
    private Integer qrCodeScan;
    /**
     * 扫码剩余次数
     */
    @TableField("remain_count")
    private Integer remainCount;
    /**
     * 多次领取 1-是 0-否
     */
    @TableField("multiple_claim")
    private Integer multipleClaim;
    /**
     * 生效时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField("start_time")
    private Date startTime;
    /**
     * 失效时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField("end_time")
    private Date endTime;
    /**
     * 操作人
     */
    @TableField("user_name")
    private String userName;
    /**
     * 创建时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    @TableField(value = "create_time", fill = FieldFill.INSERT)
    private Date createTime;
}