/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.lib;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class DynamicParseUtil {
    private DynamicLibParseHandler handler;
    private SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
    private SAXParser saxParser;

    public String compareLibName(String currentSystem, String libName) {
        String dynamicLibName = libName;
        List<String> libs = this.handler.getLibsBySystem(currentSystem);
        if (currentSystem.toLowerCase().contains("win")) {
            return this.findLibs(libs, libName);
        }
        if (libName.startsWith("lib")) {
            dynamicLibName = libName.substring(3);
        }
        return this.findLibs(libs, dynamicLibName);
    }

    private String findLibs(List<String> libs, String libName) {
        for (String lib : libs) {
            if (!libName.equalsIgnoreCase(lib)) continue;
            return lib;
        }
        return "";
    }

    public List<String> getLibsSystem(String system) {
        return this.handler.getLibsBySystem(system);
    }

    private DynamicParseUtil() throws ParserConfigurationException {
        try {
            this.saxParser = this.saxParserFactory.newSAXParser();
            this.handler = new DynamicLibParseHandler();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DynamicParseUtil(InputStream inputSteam) throws ParserConfigurationException, IOException, SAXException {
        this();
        this.saxParser.parse(inputSteam, (DefaultHandler)this.handler);
    }

    private class DynamicLibParseHandler
    extends DefaultHandler {
        private HashMap<String, List<String>> dynamics = new HashMap();
        private List<String> systems = Arrays.asList("win64", "win32", "linux64", "linux32", "mac64", "linuxARM");
        private String currentDynamicSystem;
        private List<String> libs;

        private DynamicLibParseHandler() {
        }

        public List<String> getLibsBySystem(String system) {
            return this.dynamics.get(system);
        }

        @Override
        public void startDocument() throws SAXException {
            super.startDocument();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if (this.systems.contains(qName)) {
                this.currentDynamicSystem = qName;
                if (this.libs == null) {
                    this.libs = new ArrayList<String>();
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            super.endElement(uri, localName, qName);
            if (this.systems.contains(qName)) {
                this.dynamics.put(this.currentDynamicSystem, this.libs);
                this.libs = null;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            String lib = new String(ch, start, length);
            if (!lib.trim().isEmpty()) {
                this.libs.add(lib);
            }
        }
    }
}

