/*
 * Decompiled with CFR 0.152.
 */
package com.netsdk.demo.module;

import com.netsdk.demo.module.LoginModule;
import com.netsdk.lib.NetSDKLib;
import com.netsdk.lib.ToolKits;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;

public class TalkModule {
    public static NetSDKLib.LLong m_hTalkHandle = new NetSDKLib.LLong(0L);
    private static boolean m_bRecordStatus = false;

    public static boolean startTalk(int transferType, int chn) {
        NetSDKLib.NETDEV_TALKDECODE_INFO talkEncode = new NetSDKLib.NETDEV_TALKDECODE_INFO();
        talkEncode.encodeType = 1;
        talkEncode.dwSampleRate = 8000;
        talkEncode.nAudioBit = 16;
        talkEncode.nPacketPeriod = 25;
        talkEncode.write();
        if (!LoginModule.netsdk.CLIENT_SetDeviceMode(LoginModule.m_hLoginHandle, 2, talkEncode.getPointer())) {
            System.err.println("Set Talk Encode Type Failed!" + ToolKits.getErrorCodePrint());
            return false;
        }
        System.out.println("Set Talk Encode Type Succeed!");
        NetSDKLib.NET_SPEAK_PARAM speak = new NetSDKLib.NET_SPEAK_PARAM();
        speak.nMode = 0;
        speak.bEnableWait = 0;
        speak.nSpeakerChannel = 0;
        speak.write();
        if (!LoginModule.netsdk.CLIENT_SetDeviceMode(LoginModule.m_hLoginHandle, 7, speak.getPointer())) {
            System.err.println("Set Talk Speak Mode Failed!" + ToolKits.getErrorCodePrint());
            return false;
        }
        System.out.println("Set Talk Speak Mode Succeed!");
        NetSDKLib.NET_TALK_TRANSFER_PARAM talkTransfer = new NetSDKLib.NET_TALK_TRANSFER_PARAM();
        talkTransfer.bTransfer = transferType;
        talkTransfer.write();
        if (!LoginModule.netsdk.CLIENT_SetDeviceMode(LoginModule.m_hLoginHandle, 11, talkTransfer.getPointer())) {
            System.err.println("Set Talk Transfer Mode Failed!" + ToolKits.getErrorCodePrint());
            return false;
        }
        System.out.println("Set Talk Transfer Mode Succeed!");
        if (talkTransfer.bTransfer == 1) {
            IntByReference nChn = new IntByReference(chn);
            if (LoginModule.netsdk.CLIENT_SetDeviceMode(LoginModule.m_hLoginHandle, 5, nChn.getPointer())) {
                System.out.println("Set Talk Channel Succeed!");
            } else {
                System.err.println("Set Talk Channel Failed!" + ToolKits.getErrorCodePrint());
                return false;
            }
        }
        if ((m_hTalkHandle = LoginModule.netsdk.CLIENT_StartTalkEx(LoginModule.m_hLoginHandle, AudioDataCB.getInstance(), null)).longValue() == 0L) {
            System.err.println("Start Talk Failed!" + ToolKits.getErrorCodePrint());
            return false;
        }
        System.out.println("Start Talk Success");
        if (!LoginModule.netsdk.CLIENT_RecordStart()) {
            System.err.println("Start Local Record Failed!" + ToolKits.getErrorCodePrint());
            TalkModule.stopTalk();
            return false;
        }
        System.out.println("Start Record Success");
        m_bRecordStatus = true;
        return true;
    }

    public static void stopTalk() {
        if (m_hTalkHandle.longValue() == 0L) {
            return;
        }
        if (m_bRecordStatus) {
            LoginModule.netsdk.CLIENT_RecordStop();
            m_bRecordStatus = false;
        }
        if (LoginModule.netsdk.CLIENT_StopTalkEx(m_hTalkHandle)) {
            m_hTalkHandle.setValue(0L);
        } else {
            System.err.println("Stop Talk Failed!" + ToolKits.getErrorCodePrint());
        }
    }

    private static class AudioDataCB
    implements NetSDKLib.pfAudioDataCallBack {
        private static AudioDataCB audioCallBack = new AudioDataCB();

        private AudioDataCB() {
        }

        public static AudioDataCB getInstance() {
            return audioCallBack;
        }

        @Override
        public void invoke(NetSDKLib.LLong lTalkHandle, Pointer pDataBuf, int dwBufSize, byte byAudioFlag, Pointer dwUser) {
            if (lTalkHandle.longValue() != m_hTalkHandle.longValue()) {
                return;
            }
            if (byAudioFlag == 0) {
                NetSDKLib.LLong lSendSize = LoginModule.netsdk.CLIENT_TalkSendData(m_hTalkHandle, pDataBuf, dwBufSize);
                if (lSendSize.longValue() != (long)dwBufSize) {
                    System.err.println("send incomplete" + lSendSize.longValue() + ":" + dwBufSize);
                }
            } else if (byAudioFlag == 1) {
                LoginModule.netsdk.CLIENT_AudioDecEx(m_hTalkHandle, pDataBuf, dwBufSize);
            }
        }
    }
}

