/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.dubbo.util;

import com.alibaba.cloud.dubbo.metadata.RevisionResolver;
import com.alibaba.cloud.dubbo.util.JSONUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

public class DubboMetadataUtils {
    public static final String DUBBO_PROTOCOLS_PORT_PROPERTY_NAME_PATTERN = "dubbo.protocols.%s.port";
    private final JSONUtils jsonUtils;
    private final Environment environment;
    private final String currentApplicationName;

    public DubboMetadataUtils(JSONUtils jsonUtils, Environment environment) {
        this.jsonUtils = jsonUtils;
        this.environment = environment;
        this.currentApplicationName = environment.getProperty("spring.application.name", environment.getProperty("dubbo.application.name", "application"));
    }

    public String getCurrentApplicationName() {
        return this.currentApplicationName;
    }

    public List<URL> getDubboMetadataServiceURLs(ServiceInstance serviceInstance) {
        Map metadata = serviceInstance.getMetadata();
        String dubboURLsJSON = (String)metadata.get("dubbo.metadata-service.urls");
        List<Object> urls = this.jsonUtils.toURLs(dubboURLsJSON);
        String revision = RevisionResolver.getRevision(serviceInstance);
        urls = urls.stream().map(url -> url.addParameter("sca_revision", revision)).collect(Collectors.toList());
        return urls;
    }

    public List<URL> getDubboMetadataServiceURLs(List<ServiceInstance> serviceInstances, String serviceInterface, String version, String protocol) {
        return serviceInstances.stream().map(this::getDubboMetadataServiceURLs).flatMap(Collection::stream).filter(url -> protocol == null || Objects.equals(protocol, url.getProtocol())).filter(url -> Objects.equals(serviceInterface, url.getServiceInterface())).filter(url -> Objects.equals(version, url.getParameter("version"))).collect(Collectors.toList());
    }

    public String getDubboProtocolPropertyName(String protocol) {
        return String.format(DUBBO_PROTOCOLS_PORT_PROPERTY_NAME_PATTERN, protocol);
    }

    public Integer getDubboProtocolPort(ServiceInstance serviceInstance, String protocol) {
        String protocolProperty = this.getDubboProtocolPropertyName(protocol);
        Map metadata = serviceInstance.getMetadata();
        String protocolPort = (String)metadata.get(protocolProperty);
        return StringUtils.hasText((String)protocolPort) ? Integer.valueOf(protocolPort) : null;
    }
}

