/*
 * Decompiled with CFR 0.152.
 */
package org.vafer.jdependency;

import java.util.HashSet;
import java.util.Set;
import org.vafer.jdependency.ClazzpathUnit;

public final class Clazz
implements Comparable {
    private final Set<Clazz> dependencies = new HashSet<Clazz>();
    private final Set<Clazz> references = new HashSet<Clazz>();
    private final Set<ClazzpathUnit> units = new HashSet<ClazzpathUnit>();
    private final String name;

    public Clazz(String pName) {
        this.name = pName;
    }

    public String getName() {
        return this.name;
    }

    public void addClazzpathUnit(ClazzpathUnit pUnit) {
        this.units.add(pUnit);
    }

    public void removeClazzpathUnit(ClazzpathUnit pUnit) {
        this.units.remove(pUnit);
    }

    public Set getClazzpathUnits() {
        return this.units;
    }

    public void addDependency(Clazz pClazz) {
        pClazz.references.add(this);
        this.dependencies.add(pClazz);
    }

    public void removeDependency(Clazz pClazz) {
        pClazz.references.remove(this);
        this.dependencies.remove(pClazz);
    }

    public Set getDependencies() {
        return this.dependencies;
    }

    public Set getReferences() {
        return this.references;
    }

    public Set getTransitiveDependencies() {
        HashSet all = new HashSet();
        this.findTransitiveDependencies(all);
        return all;
    }

    void findTransitiveDependencies(Set pAll) {
        for (Clazz clazz : this.dependencies) {
            if (pAll.contains(clazz)) continue;
            pAll.add(clazz);
            clazz.findTransitiveDependencies(pAll);
        }
    }

    public boolean equals(Object pO) {
        if (pO.getClass() != Clazz.class) {
            return false;
        }
        Clazz c = (Clazz)pO;
        return this.name.equals(c.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public int compareTo(Object pO) {
        return this.name.compareTo(((Clazz)pO).name);
    }

    public String toString() {
        return this.name;
    }
}

