/*
 * Decompiled with CFR 0.152.
 */
package net.logstash.logback.composite.loggingevent;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.ThrowableProxy;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import net.logstash.logback.composite.AbstractFieldJsonProvider;
import net.logstash.logback.composite.FieldNamesAware;
import net.logstash.logback.composite.JsonWritingUtils;
import net.logstash.logback.fieldnames.LogstashFieldNames;

public class RootStackTraceElementJsonProvider
extends AbstractFieldJsonProvider<ILoggingEvent>
implements FieldNamesAware<LogstashFieldNames> {
    public static final String FIELD_CLASS_NAME = "class_name";
    public static final String FIELD_METHOD_NAME = "method_name";
    public static final String FIELD_STACKTRACE_ELEMENT = "root_stack_trace_element";
    private String classFieldName = "class_name";
    private String methodFieldName = "method_name";

    public RootStackTraceElementJsonProvider() {
        this.setFieldName(FIELD_STACKTRACE_ELEMENT);
    }

    @Override
    public void writeTo(JsonGenerator generator, ILoggingEvent event) throws IOException {
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (throwableProxy != null && throwableProxy instanceof ThrowableProxy && throwableProxy.getStackTraceElementProxyArray().length > 0) {
            StackTraceElement stackTraceElement = throwableProxy.getStackTraceElementProxyArray()[0].getStackTraceElement();
            generator.writeObjectFieldStart(this.getFieldName());
            JsonWritingUtils.writeStringField(generator, this.classFieldName, stackTraceElement.getClassName());
            JsonWritingUtils.writeStringField(generator, this.methodFieldName, stackTraceElement.getMethodName());
            generator.writeEndObject();
        }
    }

    @Override
    public void setFieldNames(LogstashFieldNames fieldNames) {
        this.setFieldName(fieldNames.getRootStackTraceElement());
        this.setClassFieldName(fieldNames.getRootStackTraceElementClass());
        this.setMethodFieldName(fieldNames.getRootStackTraceElementMethod());
    }

    public void setClassFieldName(String classFieldName) {
        this.classFieldName = classFieldName;
    }

    public void setMethodFieldName(String methodFieldName) {
        this.methodFieldName = methodFieldName;
    }
}

