/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.ext;

import com.mks.api.CmdRunner;
import com.mks.api.CmdRunnerCreator;
import com.mks.api.Command;
import com.mks.api.IntegrationPoint;
import com.mks.api.IntegrationPointFactory;
import com.mks.api.VersionNumber;
import com.mks.api.ext.CommandOptions;
import com.mks.api.ext.CommandSelection;
import com.mks.api.ext.ResponseWriter;
import com.mks.api.ext.VersionedIntegrationCommand;
import com.mks.api.response.APIException;
import com.mks.api.response.APIInternalError;
import com.mks.api.response.Response;
import com.mks.api.response.WorkItem;
import com.mks.api.util.APIVersion;
import java.util.Iterator;

public abstract class SimpleIntegrationCommand
implements VersionedIntegrationCommand {
    private VersionNumber apiVersion;
    private IntegrationPoint localIP;
    private CmdRunnerCreator cmdFactory;

    protected SimpleIntegrationCommand() {
    }

    protected SimpleIntegrationCommand(int apiMajorNumber, int apiMinorNumber) {
        this.apiVersion = new APIVersion(apiMajorNumber, apiMinorNumber);
    }

    public final VersionNumber getAPIExecutionVersion() {
        return this.apiVersion;
    }

    protected final VersionNumber getAPIRequestVersion() {
        if (this.localIP == null) {
            return null;
        }
        return this.localIP.getAPIRequestVersion();
    }

    public void setDefaultHostname(String host) {
        if (this.cmdFactory == null) {
            throw new APIInternalError("CmdRunnerCreator not initialized");
        }
        this.cmdFactory.setDefaultHostname(host);
    }

    public void setDefaultImpersonationUser(String impUser) {
        if (this.cmdFactory == null) {
            throw new APIInternalError("CmdRunnerCreator not initialized");
        }
        this.cmdFactory.setDefaultImpersonationUser(impUser);
    }

    public void setDefaultPassword(String pass) {
        if (this.cmdFactory == null) {
            throw new APIInternalError("CmdRunnerCreator not initialized");
        }
        this.cmdFactory.setDefaultPassword(pass);
    }

    public void setDefaultPort(int port) {
        if (this.cmdFactory == null) {
            throw new APIInternalError("CmdRunnerCreator not initialized");
        }
        this.cmdFactory.setDefaultPort(port);
    }

    public void setDefaultUsername(String user) {
        if (this.cmdFactory == null) {
            throw new APIInternalError("CmdRunnerCreator not initialized");
        }
        this.cmdFactory.setDefaultUsername(user);
    }

    public IntegrationPoint getLocalIntegrationPoint() {
        return this.localIP;
    }

    protected CmdRunnerCreator getLocalCmdRunnerCreator() {
        return this.cmdFactory;
    }

    protected int getExitCode() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int execute(IntegrationPoint localIP, CmdRunnerCreator cmdFactory, ResponseWriter apiout, CommandOptions options, CommandSelection selection) throws APIException {
        try {
            this.localIP = localIP;
            this.cmdFactory = cmdFactory;
            this.apiVersion = cmdFactory.getAPIRequestVersion();
            this.execute(apiout, options, selection);
            int n = this.getExitCode();
            return n;
        }
        finally {
            this.release();
        }
    }

    protected abstract void execute(ResponseWriter var1, CommandOptions var2, CommandSelection var3) throws APIException;

    private void release() {
        Iterator it = this.cmdFactory.getCmdRunners();
        while (it.hasNext()) {
            CmdRunner c = (CmdRunner)it.next();
            try {
                c.interrupt();
                c.release();
            }
            catch (APIException cleanupEx) {
                IntegrationPointFactory.getLogger().exception("ERROR", cleanupEx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response runLocalCommand(String[] command) throws APIException {
        APIException cmdEx;
        Response response;
        block9: {
            response = null;
            cmdEx = null;
            CmdRunner c = this.cmdFactory.createCmdRunner();
            try {
                response = c.execute(command);
            }
            catch (APIException ex) {
                cmdEx = ex;
                response = ex.getResponse();
                if (response == null || response.getWorkItemListSize() != 1) break block9;
                try {
                    WorkItem wi = response.getWorkItems().next();
                    if (wi.getAPIException() != null) {
                        throw wi.getAPIException();
                    }
                }
                catch (APIException wiex) {
                    cmdEx = wiex;
                }
            }
            finally {
                c.setDefaultPassword(null);
            }
        }
        if (cmdEx != null) {
            throw cmdEx;
        }
        return response;
    }

    public final Response runLocalCommand(Command command) throws APIException {
        return this.runLocalCommand(command.toStringArray());
    }

    public Response invokeLocalCommand(String[] command) throws APIException {
        return this.invokeLocalCommand(command, true);
    }

    public Response invokeLocalCommand(Command command) throws APIException {
        return this.invokeLocalCommand(command, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response invokeLocalCommand(String[] command, boolean enableCache) throws APIException {
        CmdRunner c = this.cmdFactory.createCmdRunner();
        try {
            Response response = c.executeWithInterim(command, enableCache);
            return response;
        }
        finally {
            c.setDefaultPassword(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response invokeLocalCommand(Command command, boolean enableCache) throws APIException {
        CmdRunner c = this.cmdFactory.createCmdRunner();
        try {
            Response response = c.executeWithInterim(command, enableCache);
            return response;
        }
        finally {
            c.setDefaultPassword(null);
        }
    }
}

