/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.rubygems.layout;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import org.torquebox.mojo.rubygems.BundlerApiFile;
import org.torquebox.mojo.rubygems.DependencyFile;
import org.torquebox.mojo.rubygems.DependencyHelper;
import org.torquebox.mojo.rubygems.GemFile;
import org.torquebox.mojo.rubygems.GemspecFile;
import org.torquebox.mojo.rubygems.GemspecHelper;
import org.torquebox.mojo.rubygems.RubygemsGateway;
import org.torquebox.mojo.rubygems.layout.GETLayout;
import org.torquebox.mojo.rubygems.layout.ProxyStorage;

public class ProxiedGETLayout
extends GETLayout {
    private final ProxyStorage store;

    public ProxiedGETLayout(RubygemsGateway gateway, ProxyStorage store) {
        super(gateway, store);
        this.store = store;
    }

    private void maybeCreate(GemspecFile gemspec) {
        block4: {
            if (gemspec.notExists() || gemspec.hasException()) {
                Exception exp = gemspec.getException();
                GemFile gem = gemspec.gem();
                this.store.retrieve(gem);
                if (gem.exists()) {
                    try {
                        GemspecHelper helper = this.gateway.newGemspecHelperFromGem(this.store.getInputStream(gem));
                        this.store.update(helper.getRzInputStream(), gemspec);
                        this.store.expireNow(gemspec);
                    }
                    catch (IOException e) {
                        if (exp == null) break block4;
                        gemspec.setException(exp);
                    }
                }
            }
        }
    }

    @Override
    public GemspecFile gemspecFile(String name, String version, String platform) {
        GemspecFile gemspec = super.gemspecFile(name, version, platform);
        this.maybeCreate(gemspec);
        return gemspec;
    }

    @Override
    public GemspecFile gemspecFile(String filename) {
        GemspecFile gemspec = super.gemspecFile(filename);
        this.maybeCreate(gemspec);
        return gemspec;
    }

    @Override
    public DependencyFile dependencyFile(String name) {
        DependencyFile file = super.dependencyFile(name);
        this.store.retrieve(file);
        return file;
    }

    @Override
    protected void retrieveAll(BundlerApiFile file, DependencyHelper deps) throws IOException {
        block53: {
            Throwable throwable;
            InputStream is;
            LinkedList<String> expiredNames = new LinkedList<String>();
            for (String string : file.gemnames()) {
                DependencyFile dep2 = super.dependencyFile(string);
                if (this.store.isExpired(dep2)) {
                    expiredNames.add(string);
                    continue;
                }
                this.store.retrieve(dep2);
                is = this.store.getInputStream(dep2);
                throwable = null;
                try {
                    deps.add(is);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is != null) {
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            is.close();
                        }
                    }
                }
            }
            if (expiredNames.size() <= 0) break block53;
            BundlerApiFile expired = super.bundlerApiFile(expiredNames.toArray(new String[expiredNames.size()]));
            this.store.retrieve(expired);
            if (expired.hasException()) {
                file.setException(expired.getException());
            } else if (expired.hasPayload()) {
                DependencyHelper bundlerDeps = this.gateway.newDependencyHelper();
                Throwable throwable4 = null;
                try (InputStream bundlerResult = this.store.getInputStream(expired);){
                    bundlerDeps.add(bundlerResult);
                }
                catch (Throwable dep2) {
                    Throwable throwable5 = dep2;
                    throw dep2;
                }
                for (String string : expiredNames) {
                    DependencyFile dep = super.dependencyFile(string);
                    this.store.update(bundlerDeps.getInputStreamOf(string), dep);
                    is = this.store.getInputStream(dep);
                    throwable = null;
                    try {
                        deps.add(is);
                    }
                    catch (Throwable throwable6) {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable7) {
                                throwable.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
            } else {
                for (String name : expiredNames) {
                    DependencyFile dependencyFile = super.dependencyFile(name);
                    this.store.retrieve(dependencyFile);
                    InputStream is2 = this.store.getInputStream(dependencyFile);
                    Throwable throwable8 = null;
                    try {
                        deps.add(is2);
                    }
                    catch (Throwable throwable9) {
                        throwable8 = throwable9;
                        throw throwable9;
                    }
                    finally {
                        if (is2 == null) continue;
                        if (throwable8 != null) {
                            try {
                                is2.close();
                            }
                            catch (Throwable throwable10) {
                                throwable8.addSuppressed(throwable10);
                            }
                            continue;
                        }
                        is2.close();
                    }
                }
            }
        }
    }
}

