/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.rubygems.layout;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.jruby.runtime.builtin.IRubyObject;
import org.torquebox.mojo.rubygems.ApiV1File;
import org.torquebox.mojo.rubygems.DependencyFile;
import org.torquebox.mojo.rubygems.FileType;
import org.torquebox.mojo.rubygems.GemFile;
import org.torquebox.mojo.rubygems.GemspecFile;
import org.torquebox.mojo.rubygems.GemspecHelper;
import org.torquebox.mojo.rubygems.IOUtil;
import org.torquebox.mojo.rubygems.RubygemsFile;
import org.torquebox.mojo.rubygems.RubygemsGateway;
import org.torquebox.mojo.rubygems.SpecsHelper;
import org.torquebox.mojo.rubygems.SpecsIndexFile;
import org.torquebox.mojo.rubygems.SpecsIndexType;
import org.torquebox.mojo.rubygems.SpecsIndexZippedFile;
import org.torquebox.mojo.rubygems.layout.NoopDefaultLayout;
import org.torquebox.mojo.rubygems.layout.Storage;

public class HostedPOSTLayout
extends NoopDefaultLayout {
    public HostedPOSTLayout(RubygemsGateway gateway, Storage store) {
        super(gateway, store);
    }

    @Override
    public void addGem(InputStream in, RubygemsFile file) {
        if (file.type() != FileType.GEM && file.type() != FileType.API_V1) {
            throw new RuntimeException("BUG: not allowed to store " + file);
        }
        try {
            GemspecHelper spec;
            this.store.create(in, file);
            if (file.hasNoPayload()) {
                return;
            }
            try (InputStream is = this.store.getInputStream(file);){
                spec = this.gateway.newGemspecHelperFromGem(is);
            }
            switch (file.type()) {
                case GEM: {
                    if ((((GemFile)file).filename() + ".gem").equals(spec.filename())) break;
                    this.store.delete(file);
                    file.setException(new IOException("filename " + file.name() + " does not match gemname: " + spec.filename()));
                    return;
                }
                case API_V1: {
                    is = this.store.getInputStream(file);
                    var5_4 = null;
                    try {
                        this.store.create(is, ((ApiV1File)file).gem(spec.filename()));
                    }
                    catch (Throwable throwable) {
                        var5_4 = throwable;
                        throw throwable;
                    }
                    finally {
                        if (is != null) {
                            if (var5_4 != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable throwable) {
                                    var5_4.addSuppressed(throwable);
                                }
                            } else {
                                is.close();
                            }
                        }
                    }
                    this.store.delete(file);
                    break;
                }
                default: {
                    throw new RuntimeException("BUG");
                }
            }
            this.addSpecToIndex(spec.gemspec());
            this.delete(super.dependencyFile(spec.name()));
            this.delete(super.gemspecFile(spec.filename().replaceFirst(".gem$", "")));
        }
        catch (IOException e) {
            file.setException(e);
        }
    }

    private void addSpecToIndex(IRubyObject spec) throws IOException {
        SpecsHelper specs = this.gateway.newSpecsHelper();
        for (SpecsIndexType type : SpecsIndexType.values()) {
            SpecsIndexZippedFile specsIndex = this.ensureSpecsIndexZippedFile(type);
            ByteArrayInputStream gzippedResult = null;
            try (GZIPInputStream in = new GZIPInputStream(this.store.getInputStream(specsIndex));
                 ByteArrayInputStream result = specs.addSpec(spec, in, type);){
                if (result != null) {
                    gzippedResult = IOUtil.toGzipped(result);
                }
            }
            if (gzippedResult == null) continue;
            this.store.update(gzippedResult, specsIndex);
        }
    }

    @Override
    public ApiV1File apiV1File(String name) {
        ApiV1File apiV1 = super.apiV1File(name);
        if (!"api_key".equals(apiV1.name())) {
            apiV1.markAsForbidden();
        }
        return apiV1;
    }

    @Override
    public SpecsIndexFile specsIndexFile(SpecsIndexType type) {
        SpecsIndexFile file = super.specsIndexFile(type);
        file.markAsForbidden();
        return file;
    }

    @Override
    public SpecsIndexZippedFile specsIndexZippedFile(SpecsIndexType type) {
        SpecsIndexZippedFile file = super.specsIndexZippedFile(type);
        file.markAsForbidden();
        return file;
    }

    @Override
    public SpecsIndexFile specsIndexFile(String name) {
        SpecsIndexFile file = super.specsIndexFile(name);
        file.markAsForbidden();
        return file;
    }

    @Override
    public SpecsIndexZippedFile specsIndexZippedFile(String name) {
        SpecsIndexZippedFile file = super.specsIndexZippedFile(name);
        file.markAsForbidden();
        return file;
    }

    @Override
    public GemspecFile gemspecFile(String name, String version, String platform) {
        GemspecFile file = super.gemspecFile(name, version, platform);
        file.markAsForbidden();
        return file;
    }

    @Override
    public GemspecFile gemspecFile(String name) {
        GemspecFile file = super.gemspecFile(name);
        file.markAsForbidden();
        return file;
    }

    @Override
    public DependencyFile dependencyFile(String name) {
        DependencyFile file = super.dependencyFile(name);
        file.markAsForbidden();
        return file;
    }
}

