/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.rubygems.layout;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import org.jruby.runtime.builtin.IRubyObject;
import org.torquebox.mojo.rubygems.ApiV1File;
import org.torquebox.mojo.rubygems.DependencyFile;
import org.torquebox.mojo.rubygems.GemFile;
import org.torquebox.mojo.rubygems.GemspecFile;
import org.torquebox.mojo.rubygems.GemspecHelper;
import org.torquebox.mojo.rubygems.IOUtil;
import org.torquebox.mojo.rubygems.RubygemsGateway;
import org.torquebox.mojo.rubygems.SpecsHelper;
import org.torquebox.mojo.rubygems.SpecsIndexFile;
import org.torquebox.mojo.rubygems.SpecsIndexType;
import org.torquebox.mojo.rubygems.SpecsIndexZippedFile;
import org.torquebox.mojo.rubygems.layout.NoopDefaultLayout;
import org.torquebox.mojo.rubygems.layout.Storage;

public class HostedDELETELayout
extends NoopDefaultLayout {
    public HostedDELETELayout(RubygemsGateway gateway, Storage store) {
        super(gateway, store);
    }

    @Override
    public SpecsIndexFile specsIndexFile(String name) {
        SpecsIndexFile file = super.specsIndexFile(name);
        file.markAsForbidden();
        return file;
    }

    @Override
    public GemspecFile gemspecFile(String name, String version, String platform) {
        GemspecFile file = super.gemspecFile(name, version, platform);
        file.markAsForbidden();
        return file;
    }

    @Override
    public GemspecFile gemspecFile(String name) {
        GemspecFile file = super.gemspecFile(name);
        file.markAsForbidden();
        return file;
    }

    @Override
    public DependencyFile dependencyFile(String name) {
        DependencyFile file = super.dependencyFile(name);
        file.markAsForbidden();
        return file;
    }

    @Override
    public ApiV1File apiV1File(String name) {
        ApiV1File file = super.apiV1File(name);
        file.markAsForbidden();
        return file;
    }

    @Override
    public GemFile gemFile(String name, String version, String platform) {
        GemFile file = super.gemFile(name, version, platform);
        this.deleteGemFile(file);
        return file;
    }

    @Override
    public GemFile gemFile(String name) {
        GemFile file = super.gemFile(name);
        this.deleteGemFile(file);
        return file;
    }

    private void deleteGemFile(GemFile file) {
        this.store.retrieve(file);
        try (InputStream is = this.store.getInputStream(file);){
            GemspecHelper spec = this.gateway.newGemspecHelperFromGem(is);
            this.deleteSpecFromIndex(spec.gemspec());
            this.delete(super.dependencyFile(spec.name()));
            this.delete(super.gemspecFile(file.filename()));
        }
        catch (IOException e) {
            file.setException(e);
        }
        this.store.delete(file);
    }

    private void deleteSpecFromIndex(IRubyObject spec) throws IOException {
        SpecsHelper specs = this.gateway.newSpecsHelper();
        for (SpecsIndexType type : SpecsIndexType.values()) {
            SpecsIndexZippedFile specsIndex = this.ensureSpecsIndexZippedFile(type);
            try (GZIPInputStream in = new GZIPInputStream(this.store.getInputStream(specsIndex));
                 ByteArrayInputStream result = specs.deleteSpec(spec, in, type);){
                if (result == null) continue;
                this.store.update(IOUtil.toGzipped(result), specsIndex);
            }
        }
    }
}

