/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.rubygems;

import org.torquebox.mojo.rubygems.FileType;
import org.torquebox.mojo.rubygems.RubygemsFileFactory;

public class RubygemsFile {
    final RubygemsFileFactory factory;
    private final String name;
    private final String storage;
    private final String remote;
    private final FileType type;
    private Object payload;
    private State state = State.NEW_INSTANCE;

    RubygemsFile(RubygemsFileFactory factory, FileType type, String storage, String remote, String name) {
        this.factory = factory;
        this.type = type;
        this.storage = storage;
        this.remote = remote;
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public String storagePath() {
        return this.storage;
    }

    public String remotePath() {
        return this.remote;
    }

    public FileType type() {
        return this.type;
    }

    public State state() {
        return this.state;
    }

    protected void addToString(StringBuilder builder) {
        builder.append("type=").append(this.type.name()).append(", storage=").append(this.storage).append(", remote=").append(this.remote);
        if (this.name != null) {
            builder.append(", name=").append(this.name);
        }
        builder.append(", state=").append(this.state.name());
        if (this.state == State.ERROR) {
            builder.append(", exception=").append(this.getException().getClass().getSimpleName()).append(": ").append(this.getException().getMessage());
        } else if (this.state == State.PAYLOAD) {
            builder.append(", payload=").append(this.get().toString());
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RubygemsFile[");
        this.addToString(builder);
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.remote == null ? 0 : this.remote.hashCode());
        result = 31 * result + (this.storage == null ? 0 : this.storage.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RubygemsFile other = (RubygemsFile)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.remote == null ? other.remote != null : !this.remote.equals(other.remote)) {
            return false;
        }
        if (this.storage == null ? other.storage != null : !this.storage.equals(other.storage)) {
            return false;
        }
        return this.type == other.type;
    }

    public Object get() {
        return this.payload;
    }

    public void set(Object payload) {
        this.state = payload == null ? State.NO_PAYLOAD : State.PAYLOAD;
        this.payload = payload;
    }

    public void setException(Exception e) {
        this.set(e);
        this.state = State.ERROR;
    }

    public Exception getException() {
        if (this.hasException()) {
            return (Exception)this.payload;
        }
        return null;
    }

    public boolean hasException() {
        return this.state == State.ERROR;
    }

    public void resetState() {
        this.payload = null;
        this.state = State.NEW_INSTANCE;
    }

    public boolean exists() {
        return this.state == State.NEW_INSTANCE || this.state == State.NO_PAYLOAD || this.state == State.PAYLOAD;
    }

    public boolean notExists() {
        return this.state == State.NOT_EXISTS;
    }

    public boolean hasNoPayload() {
        return this.state == State.NO_PAYLOAD;
    }

    public boolean hasPayload() {
        return this.state == State.PAYLOAD;
    }

    public boolean forbidden() {
        return this.state == State.FORBIDDEN;
    }

    public void markAsNotExists() {
        this.state = State.NOT_EXISTS;
    }

    public void markAsTempUnavailable() {
        this.state = State.TEMP_UNAVAILABLE;
    }

    public void markAsForbidden() {
        this.state = State.FORBIDDEN;
    }

    public static enum State {
        NEW_INSTANCE,
        NOT_EXISTS,
        ERROR,
        NO_PAYLOAD,
        TEMP_UNAVAILABLE,
        FORBIDDEN,
        PAYLOAD;

    }
}

