/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.rubygems;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class IOUtil {
    public static void copy(InputStream input, OutputStream output) throws IOException {
        byte[] buffer = new byte[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
        }
    }

    public static ByteArrayInputStream toGzipped(InputStream input) throws IOException {
        ByteArrayOutputStream gzipped = new ByteArrayOutputStream();
        try (GZIPOutputStream out = new GZIPOutputStream(gzipped);){
            IOUtil.copy(input, out);
        }
        return new ByteArrayInputStream(gzipped.toByteArray());
    }

    public static ByteArrayInputStream toGunzipped(InputStream input) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtil.copy(new GZIPInputStream(input), out);
        return new ByteArrayInputStream(out.toByteArray());
    }
}

