/*
 * Decompiled with CFR 0.152.
 */
package org.torquebox.mojo.rubygems;

import java.io.InputStream;
import org.jruby.embed.ScriptingContainer;
import org.torquebox.mojo.rubygems.DependencyData;
import org.torquebox.mojo.rubygems.DependencyHelper;
import org.torquebox.mojo.rubygems.GemspecHelper;
import org.torquebox.mojo.rubygems.MergeSpecsHelper;
import org.torquebox.mojo.rubygems.RubygemsGateway;
import org.torquebox.mojo.rubygems.SpecsHelper;

public class DefaultRubygemsGateway
implements RubygemsGateway {
    private final ScriptingContainer container;
    private Object dependencyHelperImplClass;
    private Object gemspecHelperImplClass;
    private Object specsHelperImplClass;
    private Object mergeSpecsHelperImplClass;
    private Object dependencyDataImplClass;

    public DefaultRubygemsGateway(ScriptingContainer container) {
        this.container = container;
        this.dependencyHelperImplClass = container.runScriptlet("require 'nexus/dependency_helper_impl';Nexus::DependencyHelperImpl");
        this.gemspecHelperImplClass = container.runScriptlet("require 'nexus/gemspec_helper_impl';Nexus::GemspecHelperImpl");
        this.specsHelperImplClass = container.runScriptlet("require 'nexus/specs_helper_impl';Nexus::SpecsHelperImpl");
        this.mergeSpecsHelperImplClass = container.runScriptlet("require 'nexus/merge_specs_helper_impl';Nexus::MergeSpecsHelperImpl");
        this.dependencyDataImplClass = container.runScriptlet("require 'nexus/dependency_data_impl';Nexus::DependencyDataImpl");
    }

    @Override
    public void terminate() {
        this.dependencyHelperImplClass = null;
        this.gemspecHelperImplClass = null;
        this.specsHelperImplClass = null;
        this.mergeSpecsHelperImplClass = null;
        this.dependencyDataImplClass = null;
        this.container.terminate();
    }

    @Override
    public SpecsHelper newSpecsHelper() {
        return (SpecsHelper)this.container.callMethod(this.specsHelperImplClass, "new", SpecsHelper.class);
    }

    @Override
    public MergeSpecsHelper newMergeSpecsHelper() {
        return (MergeSpecsHelper)this.container.callMethod(this.mergeSpecsHelperImplClass, "new", MergeSpecsHelper.class);
    }

    @Override
    public DependencyHelper newDependencyHelper() {
        return (DependencyHelper)this.container.callMethod(this.dependencyHelperImplClass, "new", DependencyHelper.class);
    }

    @Override
    public GemspecHelper newGemspecHelper(InputStream gemspec) {
        return (GemspecHelper)this.container.callMethod(this.gemspecHelperImplClass, "from_gemspec_rz", (Object)gemspec, GemspecHelper.class);
    }

    @Override
    public GemspecHelper newGemspecHelperFromGem(InputStream gem) {
        return (GemspecHelper)this.container.callMethod(this.gemspecHelperImplClass, "from_gem", (Object)gem, GemspecHelper.class);
    }

    @Override
    public DependencyData newDependencyData(InputStream dependency, String name, long modified) {
        return (DependencyData)this.container.callMethod(this.dependencyDataImplClass, "new", new Object[]{dependency, name, modified}, DependencyData.class);
    }
}

