/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.hint;

import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.test.context.ActiveProfiles;
import org.springframework.test.context.ActiveProfilesResolver;
import org.springframework.test.context.TestContextAnnotationUtils;
import org.springframework.test.context.aot.TestRuntimeHintsRegistrar;

class StandardTestRuntimeHints
implements TestRuntimeHintsRegistrar {
    StandardTestRuntimeHints() {
    }

    @Override
    public void registerHints(RuntimeHints runtimeHints, Class<?> testClass, ClassLoader classLoader) {
        MergedAnnotations.search((MergedAnnotations.SearchStrategy)MergedAnnotations.SearchStrategy.TYPE_HIERARCHY).withEnclosingClasses(TestContextAnnotationUtils::searchEnclosingClass).from(testClass).stream(ActiveProfiles.class).map(mergedAnnotation -> mergedAnnotation.getClass("resolver")).filter(type -> type != ActiveProfilesResolver.class).forEach(resolverClass -> this.registerDeclaredConstructors((Class<?>)resolverClass, runtimeHints));
    }

    private void registerDeclaredConstructors(Class<?> type, RuntimeHints runtimeHints) {
        runtimeHints.reflection().registerType(type, new MemberCategory[]{MemberCategory.INVOKE_DECLARED_CONSTRUCTORS});
    }
}

