/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.edge;

import java.util.Optional;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.ImmutableCapabilities;
import org.openqa.selenium.SessionNotCreatedException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebDriverInfo;
import org.openqa.selenium.edge.EdgeDriver;
import org.openqa.selenium.edge.EdgeDriverService;

public class EdgeDriverInfo
implements WebDriverInfo {
    public String getDisplayName() {
        return "Edge";
    }

    public Capabilities getCanonicalCapabilities() {
        return new ImmutableCapabilities("browserName", (Object)"MicrosoftEdge");
    }

    public boolean isSupporting(Capabilities capabilities) {
        return "MicrosoftEdge".equals(capabilities.getBrowserName()) || capabilities.getCapability("edgeOptions") != null;
    }

    public boolean isAvailable() {
        try {
            EdgeDriverService.createDefaultService();
            return true;
        }
        catch (IllegalStateException | WebDriverException e) {
            return false;
        }
    }

    public int getMaximumSimultaneousSessions() {
        return 1;
    }

    public Optional<WebDriver> createDriver(Capabilities capabilities) throws SessionNotCreatedException {
        if (!this.isAvailable() || !this.isSupporting(capabilities)) {
            return Optional.empty();
        }
        return Optional.of(new EdgeDriver(capabilities));
    }
}

