/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.fluentd.ingester.sender.retry;

import org.komamitsu.fluency.validation.annotation.Min;

public abstract class RetryStrategy {
    private final Config config;

    protected RetryStrategy(Config config) {
        this.config = config;
    }

    public abstract int getNextIntervalMillis(int var1);

    public boolean isRetriedOver(int retryCount) {
        return retryCount > this.config.getMaxRetryCount();
    }

    public int getMaxRetryCount() {
        return this.config.getMaxRetryCount();
    }

    public String toString() {
        return "RetryStrategy{config=" + this.config + '}';
    }

    public static class Config {
        @Min(value=0L)
        private int maxRetryCount = 7;

        public int getMaxRetryCount() {
            return this.maxRetryCount;
        }

        public void setMaxRetryCount(int maxRetryCount) {
            this.maxRetryCount = maxRetryCount;
        }

        public String toString() {
            return "Config{maxRetryCount=" + this.maxRetryCount + '}';
        }
    }
}

