/*
 * Decompiled with CFR 0.152.
 */
package org.komamitsu.fluency.fluentd.ingester.sender;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.komamitsu.fluency.fluentd.ingester.sender.FluentdSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiSender
extends FluentdSender {
    private static final Logger LOG = LoggerFactory.getLogger(MultiSender.class);
    private final List<FluentdSender> senders;

    public MultiSender(List<FluentdSender> senders) {
        this(new Config(), senders);
    }

    public MultiSender(Config config, List<FluentdSender> senders) {
        super(config);
        this.senders = senders;
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    protected synchronized void sendInternal(List<ByteBuffer> buffers, String ackToken) throws AllNodesUnavailableException {
        for (FluentdSender sender : this.senders) {
            boolean isAvailable = sender.isAvailable();
            LOG.trace("send(): sender={}, isAvailable={}", (Object)sender, (Object)isAvailable);
            if (!isAvailable) continue;
            try {
                if (ackToken == null) {
                    sender.send(buffers);
                } else {
                    sender.sendWithAck(buffers, ackToken);
                }
                return;
            }
            catch (IOException e) {
                LOG.warn("Failed to send: sender=" + sender + ". Trying to use next sender...", (Throwable)e);
            }
        }
        throw new AllNodesUnavailableException("All nodes are unavailable");
    }

    @Override
    public void close() throws IOException {
        IOException firstException = null;
        for (FluentdSender sender : this.senders) {
            try {
                sender.close();
            }
            catch (IOException e) {
                if (firstException != null) continue;
                firstException = e;
            }
        }
        if (firstException != null) {
            throw firstException;
        }
    }

    public List<FluentdSender> getSenders() {
        return Collections.unmodifiableList(this.senders);
    }

    public String toString() {
        return "MultiSender{senders=" + this.senders + "} " + super.toString();
    }

    public static class Config
    extends FluentdSender.Config {
    }

    public static class AllNodesUnavailableException
    extends IOException {
        public AllNodesUnavailableException(String s) {
            super(s);
        }
    }
}

