/*
 * Decompiled with CFR 0.152.
 */
package jodd.log;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import jodd.log.Logger;
import jodd.log.LoggerProvider;
import jodd.log.impl.NOPLogger;

public final class LoggerFactory {
    private static Function<String, Logger> loggerProvider;
    private static Map<String, Logger> loggers;

    public static void setLoggerProvider(LoggerProvider loggerProvider) {
        LoggerFactory.loggerProvider = loggerProvider::createLogger;
        if (loggers != null) {
            loggers.clear();
        }
    }

    public static Logger getLogger(Class clazz) {
        return LoggerFactory.getLogger(clazz.getName());
    }

    public static void enableCache() {
        loggers = new HashMap<String, Logger>();
    }

    public static Logger getLogger(String name) {
        if (loggers == null) {
            return loggerProvider.apply(name);
        }
        return loggers.computeIfAbsent(name, loggerProvider);
    }

    static {
        LoggerFactory.setLoggerProvider(NOPLogger.PROVIDER);
        loggers = new HashMap<String, Logger>();
    }
}

