/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto.dom;

import jodd.lagarto.LagartoParser;
import jodd.lagarto.dom.DOMBuilder;
import jodd.lagarto.dom.Document;
import jodd.lagarto.dom.LagartoDOMBuilderTagVisitor;
import jodd.lagarto.dom.LagartoDomBuilderConfig;

public class LagartoDOMBuilder
implements DOMBuilder {
    protected LagartoDomBuilderConfig config = new LagartoDomBuilderConfig();

    public LagartoDOMBuilder() {
        this.enableHtmlMode();
    }

    public LagartoDomBuilderConfig getConfig() {
        return this.config;
    }

    public void setConfig(LagartoDomBuilderConfig config) {
        this.config = config;
    }

    public LagartoDOMBuilder enableDebug() {
        this.config.collectErrors = true;
        this.config.setCalculatePosition(true);
        return this;
    }

    public LagartoDOMBuilder disableDebug() {
        this.config.collectErrors = false;
        this.config.setCalculatePosition(false);
        return this;
    }

    public LagartoDOMBuilder enableHtmlPlusMode() {
        this.enableHtmlMode();
        this.config.useFosterRules = true;
        this.config.unclosedTagAsOrphanCheck = true;
        return this;
    }

    public LagartoDOMBuilder enableHtmlMode() {
        this.config.ignoreWhitespacesBetweenTags = false;
        this.config.setCaseSensitive(false);
        this.config.setEnableRawTextModes(true);
        this.config.enabledVoidTags = true;
        this.config.selfCloseVoidTags = false;
        this.config.impliedEndTags = true;
        this.config.setEnableConditionalComments(false);
        this.config.setParseXmlTags(false);
        return this;
    }

    public LagartoDOMBuilder enableXhtmlMode() {
        this.config.ignoreWhitespacesBetweenTags = false;
        this.config.setCaseSensitive(true);
        this.config.setEnableRawTextModes(false);
        this.config.enabledVoidTags = true;
        this.config.selfCloseVoidTags = true;
        this.config.impliedEndTags = false;
        this.config.setEnableConditionalComments(false);
        this.config.setParseXmlTags(false);
        return this;
    }

    public LagartoDOMBuilder enableXmlMode() {
        this.config.ignoreWhitespacesBetweenTags = true;
        this.config.setCaseSensitive(true);
        this.config.setEnableRawTextModes(false);
        this.config.enabledVoidTags = false;
        this.config.selfCloseVoidTags = false;
        this.config.impliedEndTags = false;
        this.config.setEnableConditionalComments(false);
        this.config.setParseXmlTags(true);
        return this;
    }

    @Override
    public Document parse(char[] content) {
        LagartoParser lagartoParser = new LagartoParser(content, true);
        return this.doParse(lagartoParser);
    }

    @Override
    public Document parse(String content) {
        LagartoParser lagartoParser = new LagartoParser(content, true);
        return this.doParse(lagartoParser);
    }

    protected Document doParse(LagartoParser lagartoParser) {
        lagartoParser.setConfig(this.config);
        LagartoDOMBuilderTagVisitor domBuilderTagVisitor = new LagartoDOMBuilderTagVisitor(this);
        lagartoParser.parse(domBuilderTagVisitor);
        return domBuilderTagVisitor.getDocument();
    }
}

