/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium.send;

import java.util.List;
import java.util.Map;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Request;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.leshan.core.ResponseCode;
import org.eclipse.leshan.core.californium.LwM2mCoapResource;
import org.eclipse.leshan.core.californium.ResponseCodeUtil;
import org.eclipse.leshan.core.model.LwM2mModel;
import org.eclipse.leshan.core.node.codec.LwM2mDecoder;
import org.eclipse.leshan.core.request.ContentFormat;
import org.eclipse.leshan.core.request.Identity;
import org.eclipse.leshan.core.request.SendRequest;
import org.eclipse.leshan.core.response.SendResponse;
import org.eclipse.leshan.core.response.SendableResponse;
import org.eclipse.leshan.server.model.LwM2mModelProvider;
import org.eclipse.leshan.server.registration.Registration;
import org.eclipse.leshan.server.registration.RegistrationStore;
import org.eclipse.leshan.server.send.SendHandler;

public class SendResource
extends LwM2mCoapResource {
    private RegistrationStore registrationStore;
    private LwM2mDecoder decoder;
    private LwM2mModelProvider modelProvider;
    private SendHandler sendHandler;

    public SendResource(SendHandler sendHandler, LwM2mModelProvider modelProvider, LwM2mDecoder decoder, RegistrationStore registrationStore) {
        super("dp");
        this.registrationStore = registrationStore;
        this.decoder = decoder;
        this.modelProvider = modelProvider;
        this.sendHandler = sendHandler;
    }

    public void handlePOST(CoapExchange exchange) {
        Request coapRequest = exchange.advanced().getRequest();
        Identity sender = this.extractIdentity(coapRequest.getSourceContext());
        Registration registration = this.registrationStore.getRegistrationByIdentity(sender);
        if (registration == null) {
            exchange.respond(CoAP.ResponseCode.NOT_FOUND, "no registration found");
            return;
        }
        LwM2mModel model = this.modelProvider.getObjectModel(registration);
        byte[] payload = exchange.getRequestPayload();
        ContentFormat contentFormat = ContentFormat.fromCode((int)exchange.getRequestOptions().getContentFormat());
        if (!this.decoder.isSupported(contentFormat)) {
            exchange.respond(CoAP.ResponseCode.BAD_REQUEST, "Unsupported content format");
            return;
        }
        Map data = this.decoder.decodeNodes(payload, contentFormat, (List)null, model);
        SendRequest sendRequest = new SendRequest(contentFormat, data, (Object)coapRequest);
        SendableResponse sendableResponse = this.sendHandler.handleSend(registration, sendRequest);
        SendResponse response = (SendResponse)sendableResponse.getResponse();
        if (response.isSuccess()) {
            exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()));
            sendableResponse.sent();
            return;
        }
        exchange.respond(ResponseCodeUtil.toCoapResponseCode((ResponseCode)response.getCode()), response.getErrorMessage());
        sendableResponse.sent();
    }
}

