/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.server.californium;

import java.net.InetSocketAddress;
import javax.crypto.SecretKey;
import org.eclipse.californium.scandium.dtls.ConnectionId;
import org.eclipse.californium.scandium.dtls.HandshakeResultHandler;
import org.eclipse.californium.scandium.dtls.PskPublicInformation;
import org.eclipse.californium.scandium.dtls.PskSecretResult;
import org.eclipse.californium.scandium.dtls.pskstore.AdvancedPskStore;
import org.eclipse.californium.scandium.util.SecretUtil;
import org.eclipse.californium.scandium.util.ServerNames;
import org.eclipse.leshan.server.registration.Registration;
import org.eclipse.leshan.server.registration.RegistrationStore;
import org.eclipse.leshan.server.security.SecurityInfo;
import org.eclipse.leshan.server.security.SecurityStore;

public class LwM2mPskStore
implements AdvancedPskStore {
    private SecurityStore securityStore;
    private RegistrationStore registrationStore;

    public LwM2mPskStore(SecurityStore securityStore) {
        this(securityStore, null);
    }

    public LwM2mPskStore(SecurityStore securityStore, RegistrationStore registrationStore) {
        this.securityStore = securityStore;
        this.registrationStore = registrationStore;
    }

    public boolean hasEcdhePskSupported() {
        return true;
    }

    public PskSecretResult requestPskSecretResult(ConnectionId cid, ServerNames serverName, PskPublicInformation identity, String hmacAlgorithm, SecretKey otherSecret, byte[] seed, boolean useExtendedMasterSecret) {
        if (this.securityStore == null) {
            return null;
        }
        SecurityInfo info = this.securityStore.getByIdentity(identity.getPublicInfoAsString());
        if (info == null || info.getPreSharedKey() == null) {
            return new PskSecretResult(cid, identity, null);
        }
        return new PskSecretResult(cid, identity, SecretUtil.create((byte[])info.getPreSharedKey(), (String)"PSK"));
    }

    public void setResultHandler(HandshakeResultHandler resultHandler) {
    }

    public PskPublicInformation getIdentity(InetSocketAddress peerAddress, ServerNames virtualHost) {
        if (this.registrationStore == null) {
            return null;
        }
        Registration registration = this.registrationStore.getRegistrationByAdress(peerAddress);
        if (registration != null) {
            SecurityInfo securityInfo = this.securityStore.getByEndpoint(registration.getEndpoint());
            if (securityInfo != null) {
                return new PskPublicInformation(securityInfo.getIdentity());
            }
            return null;
        }
        return null;
    }
}

