/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium;

import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.leshan.client.californium.CaliforniumEndpointsManager;
import org.eclipse.leshan.client.engine.RegistrationEngine;
import org.eclipse.leshan.client.servers.ServerIdentity;
import org.eclipse.leshan.core.californium.LwM2mCoapResource;

public class LwM2mClientCoapResource
extends LwM2mCoapResource {
    protected final CaliforniumEndpointsManager endpointsManager;
    protected final RegistrationEngine registrationEngine;

    public LwM2mClientCoapResource(String name, RegistrationEngine registrationEngine, CaliforniumEndpointsManager endpointsManager) {
        super(name);
        this.registrationEngine = registrationEngine;
        this.endpointsManager = endpointsManager;
    }

    protected ServerIdentity getServer(CoapExchange exchange) {
        ServerIdentity serverIdentity = this.extractIdentity(exchange);
        if (this.registrationEngine.isAllowedToCommunicate(serverIdentity)) {
            return serverIdentity;
        }
        return null;
    }

    protected ServerIdentity getServerOrRejectRequest(CoapExchange exchange) {
        ServerIdentity server = this.getServer(exchange);
        if (server != null) {
            return server;
        }
        exchange.respond(CoAP.ResponseCode.INTERNAL_SERVER_ERROR, "unknown server");
        return null;
    }

    protected ServerIdentity extractIdentity(CoapExchange exchange) {
        return this.endpointsManager.getServerIdentity(exchange.advanced().getEndpoint(), exchange.getSourceSocketAddress());
    }
}

