/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.leshan.client.californium;

import java.net.InetSocketAddress;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.eclipse.californium.scandium.dtls.AlertMessage;
import org.eclipse.californium.scandium.dtls.CertificateMessage;
import org.eclipse.californium.scandium.dtls.HandshakeException;
import org.eclipse.leshan.client.californium.BaseCertificateVerifier;
import org.eclipse.leshan.core.util.Validate;

public class DomainIssuerCertificateVerifier
extends BaseCertificateVerifier {
    private final Certificate domainIssuerCertificate;

    public DomainIssuerCertificateVerifier(Certificate domainIssuerCertificate) {
        Validate.notNull((Object)domainIssuerCertificate);
        this.domainIssuerCertificate = domainIssuerCertificate;
    }

    @Override
    public CertPath verifyCertificate(boolean clientUsage, CertificateMessage message, InetSocketAddress peerSocket) throws HandshakeException {
        CertPath messageChain = message.getCertificateChain();
        this.validateCertificateChainNotEmpty(messageChain);
        X509Certificate receivedServerCertificate = this.validateReceivedCertificateIsSupported(messageChain);
        if (!this.domainIssuerCertificate.equals(receivedServerCertificate)) {
            AlertMessage alert = new AlertMessage(AlertMessage.AlertLevel.FATAL, AlertMessage.AlertDescription.BAD_CERTIFICATE);
            throw new HandshakeException("Certificate chain could not be validated", alert);
        }
        return messageChain;
    }
}

