/*
 * Decompiled with CFR 0.152.
 */
package scala_maven;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.strategy.SelfFirstStrategy;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import scala_maven.ScalaMojoSupport;
import scala_maven_dependency.Context;
import scala_maven_executions.JavaMainCaller;
import scala_maven_executions.MainHelper;
import util.FileUtils;

@Mojo(name="script", requiresDependencyResolution=ResolutionScope.RUNTIME, executionStrategy="always", threadSafe=true)
public class ScalaScriptMojo
extends ScalaMojoSupport {
    @Parameter(property="project.build.directory")
    protected File outputDir;
    @Parameter(property="scriptFile")
    protected File scriptFile;
    @Parameter(property="scriptEncoding", defaultValue="UTF-8")
    protected String scriptEncoding;
    @Parameter(property="script")
    protected String script;
    @Parameter(property="maven.scala.keepGeneratedScript", defaultValue="false")
    protected boolean keepGeneratedScript;
    @Parameter(property="maven.scala.includeScopes")
    protected String includeScopes;
    @Parameter(property="maven.scala.excludeScopes")
    protected String excludeScopes;
    @Parameter(property="addToClasspath")
    protected String addToClasspath;
    @Parameter(property="removeFromClasspath")
    protected String removeFromClasspath;
    private static AtomicInteger _lastScriptIndex = new AtomicInteger(0);

    private static String scriptBaseNameOf(File scriptFile, int idx) {
        if (scriptFile == null) {
            return "embeddedScript_" + idx;
        }
        int dot = scriptFile.getName().lastIndexOf(46);
        if (dot == -1) {
            return scriptFile.getName() + "_" + idx;
        }
        return scriptFile.getName().substring(0, dot) + "_" + idx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute() throws Exception {
        if (this.script == null && this.scriptFile == null) {
            throw new MojoFailureException("Either script or scriptFile must be defined");
        }
        if (this.script != null && this.scriptFile != null) {
            throw new MojoFailureException("Only one of script or scriptFile can be defined");
        }
        if (StringUtils.isEmpty((String)this.includeScopes)) {
            this.includeScopes = this.scriptFile != null ? "compile, test, runtime" : "plugin";
        }
        if (this.excludeScopes == null) {
            this.excludeScopes = "";
        }
        File scriptDir = new File(this.outputDir, ".scalaScriptGen");
        scriptDir.mkdirs();
        String baseName = ScalaScriptMojo.scriptBaseNameOf(this.scriptFile, _lastScriptIndex.incrementAndGet());
        File destFile = new File(scriptDir, baseName + ".scala");
        TreeSet<File> classpath = new TreeSet<File>();
        this.configureClasspath(classpath);
        boolean mavenProjectDependency = this.includeScopes.contains("plugin");
        this.wrapScript(destFile, mavenProjectDependency);
        try {
            URLClassLoader loader = this.createScriptClassloader(scriptDir, classpath);
            this.getLog().debug((CharSequence)("classpath : " + Arrays.asList(loader.getURLs())));
            this.compileScript(scriptDir, destFile, loader);
            this.runScript(mavenProjectDependency, loader, baseName);
        }
        finally {
            if (!this.keepGeneratedScript) {
                this.delete(scriptDir);
            }
        }
    }

    private void runScript(boolean mavenProjectDependency, URLClassLoader loader, String baseName) throws Exception {
        Class<?> compiledScript = loader.loadClass(baseName);
        ClassLoader currentCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(loader);
        try {
            try {
                Object instance;
                if (mavenProjectDependency) {
                    Constructor<?> constructor = compiledScript.getConstructor(MavenProject.class, MavenSession.class, Log.class);
                    instance = constructor.newInstance(this.project, this.session, this.getLog());
                } else {
                    instance = compiledScript.newInstance();
                }
                try {
                    compiledScript.getMethod("run", new Class[0]).invoke(instance, new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    throw e.getTargetException();
                }
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw e;
            }
            catch (ExceptionInInitializerError e) {
                if (e.getException() != null) {
                    throw e.getException();
                }
                if (e.getCause() != null) {
                    throw e.getCause();
                }
                throw e;
            }
        }
        catch (Throwable e) {
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new Exception("A " + e.getClass().getSimpleName() + " exception was thrown", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentCL);
        }
    }

    private URLClassLoader createScriptClassloader(File scriptDir, Set<File> classpath) throws Exception {
        ClassWorld w = new ClassWorld("zero", null);
        w.newRealm("mojo", ((Object)((Object)this)).getClass().getClassLoader());
        SelfFirstStrategy s = new SelfFirstStrategy(w.newRealm("scalaScript", null));
        ClassRealm rScript = s.getRealm();
        rScript.setParentClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        rScript.importFrom("mojo", "org.apache.maven");
        rScript.addURL(scriptDir.toURI().toURL());
        for (File f : classpath) {
            rScript.addURL(f.toURI().toURL());
        }
        return rScript;
    }

    protected JavaMainCaller getScalaCommand() throws Exception {
        Context sc = this.findScalaContext();
        return this.getScalaCommand(this.fork, sc.compilerMainClassName(this.scalaClassName, false));
    }

    private void compileScript(File scriptDir, File destFile, URLClassLoader loader) throws Exception {
        JavaMainCaller jcmd = this.getScalaCommand();
        jcmd.addArgs("-classpath", MainHelper.toClasspathString(loader));
        jcmd.addArgs("-d", scriptDir.getAbsolutePath());
        jcmd.addArgs("-sourcepath", scriptDir.getAbsolutePath());
        jcmd.addArgs(destFile.getAbsolutePath());
        jcmd.run(this.displayCmd);
    }

    private void configureClasspath(Set<File> classpath) throws Exception {
        TreeSet<String> includes = new TreeSet<String>(Arrays.asList(StringUtils.split((String)this.includeScopes.toLowerCase(), (String)",")));
        TreeSet<String> excludes = new TreeSet<String>(Arrays.asList(StringUtils.split((String)this.excludeScopes.toLowerCase(), (String)",")));
        for (Artifact a : this.project.getArtifacts()) {
            if (!includes.contains(a.getScope().toLowerCase()) || excludes.contains(a.getScope())) continue;
            this.addToClasspath(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getClassifier(), classpath, true);
        }
        if (includes.contains("plugin") && !excludes.contains("plugin")) {
            for (Plugin p : this.project.getBuildPlugins()) {
                if (!"scala-maven-plugin".equals(p.getArtifactId())) continue;
                for (Dependency d : p.getDependencies()) {
                    this.addToClasspath(d.getGroupId(), d.getArtifactId(), d.getVersion(), d.getClassifier(), classpath, true);
                }
            }
            for (Artifact a : this.project.getPluginArtifacts()) {
                if (!"scala-maven-plugin".equals(a.getArtifactId())) continue;
                this.addToClasspath(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getClassifier(), classpath, true);
            }
        }
        if (this.addToClasspath != null) {
            for (String s : StringUtils.split((String)this.addToClasspath, (String)",")) {
                classpath.add(new File(s));
            }
        }
        if (this.removeFromClasspath != null) {
            ArrayList<File> toRemove = new ArrayList<File>();
            String[] jars = StringUtils.split((String)this.removeFromClasspath.trim(), (String)",");
            for (File f : classpath) {
                for (String jar : jars) {
                    if (!f.getPath().contains(jar.trim())) continue;
                    toRemove.add(f);
                }
            }
            classpath.removeAll(toRemove);
        }
        this.addCompilerToClasspath(classpath);
        this.addLibraryToClasspath(classpath);
        boolean ok = true;
        for (File f : classpath) {
            this.getLog().debug((CharSequence)("classpath entry for running and compiling scripts: " + f));
            if (f.exists()) continue;
            this.getLog().error((CharSequence)("classpath entry for script not found : " + f));
            ok = false;
        }
        if (!ok) {
            throw new MojoFailureException("some script dependencies not found (see log)");
        }
        this.getLog().debug((CharSequence)("Using the following classpath for running and compiling scripts: " + classpath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void wrapScript(File destFile, boolean mavenProjectDependency) throws IOException {
        destFile.delete();
        FileOutputStream fileOutputStream = new FileOutputStream(destFile);
        PrintStream out = new PrintStream((OutputStream)fileOutputStream, false, this.encoding);
        BufferedReader reader = null;
        try {
            reader = this.scriptFile != null ? new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.scriptFile), Charset.forName(this.scriptEncoding))) : new BufferedReader(new StringReader(this.script));
            String baseName = FileUtils.basename((String)destFile.getName(), (String)".scala");
            if (mavenProjectDependency) {
                out.println("class " + baseName + "(project :" + MavenProject.class.getCanonicalName() + ",session :" + MavenSession.class.getCanonicalName() + ",log :" + Log.class.getCanonicalName() + ") {");
            } else {
                out.println("class " + baseName + " {");
            }
            String line = reader.readLine();
            while (line != null) {
                out.print("  ");
                out.println(line);
                line = reader.readLine();
            }
            out.println("}");
        }
        catch (Throwable throwable) {
            IOUtil.close((OutputStream)out);
            IOUtil.close((OutputStream)fileOutputStream);
            IOUtil.close(reader);
            throw throwable;
        }
        IOUtil.close((OutputStream)out);
        IOUtil.close((OutputStream)fileOutputStream);
        IOUtil.close((Reader)reader);
    }

    private void delete(File scriptDir) {
        if (scriptDir.isDirectory()) {
            for (File file : scriptDir.listFiles()) {
                this.delete(file);
            }
        }
        scriptDir.deleteOnExit();
        scriptDir.delete();
    }
}

