/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.prometheus;

import com.fasterxml.jackson.core.JsonGenerator;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.server.annotation.Get;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.prometheus.client.CollectorRegistry;
import java.io.IOException;
import java.io.StringWriter;
import zipkin2.server.internal.JsonUtil;

public class ZipkinMetricsController {
    final MeterRegistry meterRegistry;
    final CollectorRegistry collectorRegistry;

    ZipkinMetricsController(MeterRegistry meterRegistry, CollectorRegistry collectorRegistry) {
        this.meterRegistry = meterRegistry;
        this.collectorRegistry = collectorRegistry;
    }

    @Get(value="/metrics")
    public HttpResponse fetchMetricsFromMicrometer() throws IOException {
        StringWriter writer = new StringWriter();
        JsonGenerator generator = JsonUtil.createGenerator(writer);
        generator.writeStartObject();
        for (Meter meter : this.meterRegistry.getMeters()) {
            String transport;
            String name = meter.getId().getName();
            if (!name.startsWith("zipkin_collector") || (transport = meter.getId().getTag("transport")) == null) continue;
            Meter.Type type = meter.getId().getType();
            if (type == Meter.Type.COUNTER) {
                generator.writeNumberField("counter." + name + "." + transport, ((Counter)meter).count());
                continue;
            }
            if (type != Meter.Type.GAUGE) continue;
            generator.writeNumberField("gauge." + name + "." + transport, ((Gauge)meter).value());
        }
        generator.writeEndObject();
        generator.flush();
        return HttpResponse.of((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON, (String)writer.toString());
    }
}

