/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.transport.mysql.packet.handshake;

import com.google.common.base.Strings;
import io.shardingsphere.core.rule.Authentication;
import io.shardingsphere.shardingproxy.runtime.GlobalRegistry;
import io.shardingsphere.shardingproxy.transport.mysql.packet.handshake.AuthPluginData;
import java.util.Arrays;
import org.apache.commons.codec.digest.DigestUtils;

public final class AuthenticationHandler {
    private static final GlobalRegistry GLOBAL_REGISTRY = GlobalRegistry.getInstance();
    private final AuthPluginData authPluginData = new AuthPluginData();

    public boolean login(String username, byte[] authResponse) {
        Authentication authentication = GLOBAL_REGISTRY.getAuthentication();
        if (Strings.isNullOrEmpty((String)authentication.getPassword())) {
            return authentication.getUsername().equals(username);
        }
        return authentication.getUsername().equals(username) && Arrays.equals(this.getAuthCipherBytes(authentication.getPassword()), authResponse);
    }

    private byte[] getAuthCipherBytes(String password) {
        byte[] sha1Password = DigestUtils.sha1((String)password);
        byte[] doubleSha1Password = DigestUtils.sha1((byte[])sha1Password);
        byte[] concatBytes = new byte[this.authPluginData.getAuthPluginData().length + doubleSha1Password.length];
        System.arraycopy(this.authPluginData.getAuthPluginData(), 0, concatBytes, 0, this.authPluginData.getAuthPluginData().length);
        System.arraycopy(doubleSha1Password, 0, concatBytes, this.authPluginData.getAuthPluginData().length, doubleSha1Password.length);
        byte[] sha1ConcatBytes = DigestUtils.sha1((byte[])concatBytes);
        return this.xor(sha1Password, sha1ConcatBytes);
    }

    private byte[] xor(byte[] input, byte[] secret) {
        byte[] result = new byte[input.length];
        for (int i = 0; i < input.length; ++i) {
            result[i] = (byte)(input[i] ^ secret[i]);
        }
        return result;
    }

    public AuthPluginData getAuthPluginData() {
        return this.authPluginData;
    }
}

