/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.text.fieldlist;

import com.google.common.base.Optional;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.shardingproxy.backend.BackendHandler;
import io.shardingsphere.shardingproxy.backend.BackendHandlerFactory;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.transport.mysql.constant.ColumnType;
import io.shardingsphere.shardingproxy.transport.mysql.packet.MySQLPacketPayload;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandPacketType;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.CommandResponsePackets;
import io.shardingsphere.shardingproxy.transport.mysql.packet.command.query.ColumnDefinition41Packet;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.EofPacket;
import io.shardingsphere.shardingproxy.transport.mysql.packet.generic.ErrPacket;
import java.sql.SQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComFieldListPacket
implements CommandPacket {
    private static final Logger log = LoggerFactory.getLogger(ComFieldListPacket.class);
    private static final String SQL = "SHOW COLUMNS FROM %s FROM %s";
    private final int sequenceId;
    private final String schemaName;
    private final String table;
    private final String fieldWildcard;
    private final BackendHandler backendHandler;

    public ComFieldListPacket(int sequenceId, MySQLPacketPayload payload, BackendConnection backendConnection) {
        this.sequenceId = sequenceId;
        this.schemaName = backendConnection.getSchemaName();
        this.table = payload.readStringNul();
        this.fieldWildcard = payload.readStringEOF();
        this.backendHandler = BackendHandlerFactory.getInstance().newTextProtocolInstance(sequenceId, String.format(SQL, this.table, this.schemaName), backendConnection, DatabaseType.MySQL);
    }

    @Override
    public void write(MySQLPacketPayload payload) {
        payload.writeInt1(CommandPacketType.COM_FIELD_LIST.getValue());
        payload.writeStringNul(this.table);
        payload.writeStringEOF(this.fieldWildcard);
    }

    @Override
    public Optional<CommandResponsePackets> execute() throws SQLException {
        log.debug("Table name received for Sharding-Proxy: {}", (Object)this.table);
        log.debug("Field wildcard received for Sharding-Proxy: {}", (Object)this.fieldWildcard);
        CommandResponsePackets responsePackets = this.backendHandler.execute();
        return Optional.of((Object)(responsePackets.getHeadPacket() instanceof ErrPacket ? responsePackets : this.getColumnDefinition41Packets()));
    }

    private CommandResponsePackets getColumnDefinition41Packets() throws SQLException {
        CommandResponsePackets result = new CommandResponsePackets();
        int currentSequenceId = 0;
        while (this.backendHandler.next()) {
            String columnName = this.backendHandler.getResultValue().getData().get(0).toString();
            result.getPackets().add(new ColumnDefinition41Packet(++currentSequenceId, this.schemaName, this.table, this.table, columnName, columnName, 100, ColumnType.MYSQL_TYPE_VARCHAR, 0));
        }
        result.getPackets().add(new EofPacket(++currentSequenceId));
        return result;
    }

    @Override
    public int getSequenceId() {
        return this.sequenceId;
    }
}

