/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.runtime.schema;

import com.google.common.eventbus.Subscribe;
import io.shardingsphere.api.config.rule.ShardingRuleConfiguration;
import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import io.shardingsphere.core.metadata.ShardingMetaData;
import io.shardingsphere.core.metadata.table.executor.TableMetaDataConnectionManager;
import io.shardingsphere.core.rule.DataSourceParameter;
import io.shardingsphere.core.rule.MasterSlaveRule;
import io.shardingsphere.core.rule.ShardingRule;
import io.shardingsphere.orchestration.internal.registry.config.event.ShardingRuleChangedEvent;
import io.shardingsphere.orchestration.internal.registry.state.event.DisabledStateChangedEvent;
import io.shardingsphere.orchestration.internal.registry.state.schema.OrchestrationShardingSchema;
import io.shardingsphere.orchestration.internal.rule.OrchestrationMasterSlaveRule;
import io.shardingsphere.orchestration.internal.rule.OrchestrationShardingRule;
import io.shardingsphere.shardingproxy.backend.BackendExecutorContext;
import io.shardingsphere.shardingproxy.runtime.GlobalRegistry;
import io.shardingsphere.shardingproxy.runtime.metadata.ProxyTableMetaDataConnectionManager;
import io.shardingsphere.shardingproxy.runtime.schema.LogicSchema;
import java.util.Collection;
import java.util.Map;

public final class ShardingSchema
extends LogicSchema {
    private ShardingRule shardingRule;
    private final ShardingMetaData metaData;

    public ShardingSchema(String name, Map<String, DataSourceParameter> dataSources, ShardingRuleConfiguration shardingRuleConfig, boolean isCheckingMetaData, boolean isUsingRegistry) {
        super(name, dataSources);
        this.shardingRule = this.createShardingRule(shardingRuleConfig, dataSources.keySet(), isUsingRegistry);
        this.metaData = this.createShardingMetaData(isCheckingMetaData);
    }

    private ShardingRule createShardingRule(ShardingRuleConfiguration shardingRuleConfig, Collection<String> dataSourceNames, boolean isUsingRegistry) {
        return isUsingRegistry ? new OrchestrationShardingRule(shardingRuleConfig, dataSourceNames) : new ShardingRule(shardingRuleConfig, dataSourceNames);
    }

    private ShardingMetaData createShardingMetaData(boolean isCheckingMetaData) {
        return new ShardingMetaData(this.getDataSourceURLs(this.getDataSources()), this.shardingRule, DatabaseType.MySQL, BackendExecutorContext.getInstance().getExecuteEngine(), (TableMetaDataConnectionManager)new ProxyTableMetaDataConnectionManager(this.getBackendDataSource()), ((Integer)GlobalRegistry.getInstance().getShardingProperties().getValue(ShardingPropertiesConstant.MAX_CONNECTIONS_SIZE_PER_QUERY)).intValue(), isCheckingMetaData);
    }

    @Subscribe
    public synchronized void renew(ShardingRuleChangedEvent shardingRuleChangedEvent) {
        if (this.getName().equals(shardingRuleChangedEvent.getShardingSchemaName())) {
            this.shardingRule = new OrchestrationShardingRule(shardingRuleChangedEvent.getShardingRuleConfiguration(), this.getDataSources().keySet());
        }
    }

    @Subscribe
    public synchronized void renew(DisabledStateChangedEvent disabledStateChangedEvent) {
        OrchestrationShardingSchema shardingSchema = disabledStateChangedEvent.getShardingSchema();
        if (this.getName().equals(shardingSchema.getSchemaName())) {
            for (MasterSlaveRule each : this.shardingRule.getMasterSlaveRules()) {
                ((OrchestrationMasterSlaveRule)each).updateDisabledDataSourceNames(shardingSchema.getDataSourceName(), disabledStateChangedEvent.isDisabled());
            }
        }
    }

    public ShardingRule getShardingRule() {
        return this.shardingRule;
    }

    @Override
    public ShardingMetaData getMetaData() {
        return this.metaData;
    }
}

