/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.runtime.schema;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import io.shardingsphere.core.metadata.ShardingMetaData;
import io.shardingsphere.core.rule.DataSourceParameter;
import io.shardingsphere.orchestration.internal.eventbus.ShardingOrchestrationEventBus;
import io.shardingsphere.orchestration.internal.registry.config.event.DataSourceChangedEvent;
import io.shardingsphere.shardingproxy.backend.jdbc.datasource.JDBCBackendDataSource;
import io.shardingsphere.shardingproxy.util.DataSourceConverter;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class LogicSchema {
    private final String name;
    private final Map<String, DataSourceParameter> dataSources;
    private final EventBus eventBus = ShardingOrchestrationEventBus.getInstance();
    private JDBCBackendDataSource backendDataSource;

    public LogicSchema(String name, Map<String, DataSourceParameter> dataSources) {
        this.name = name;
        this.dataSources = dataSources;
        this.backendDataSource = new JDBCBackendDataSource(dataSources);
        this.eventBus.register((Object)this);
    }

    protected final Map<String, String> getDataSourceURLs(Map<String, DataSourceParameter> dataSourceParameters) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>(dataSourceParameters.size(), 1.0f);
        for (Map.Entry<String, DataSourceParameter> entry : dataSourceParameters.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getUrl());
        }
        return result;
    }

    public abstract ShardingMetaData getMetaData();

    @Subscribe
    public final synchronized void renew(DataSourceChangedEvent dataSourceChangedEvent) {
        if (!this.name.equals(dataSourceChangedEvent.getShardingSchemaName())) {
            return;
        }
        this.backendDataSource.close();
        this.dataSources.clear();
        this.dataSources.putAll(DataSourceConverter.getDataSourceParameterMap(dataSourceChangedEvent.getDataSourceConfigurations()));
        this.backendDataSource = new JDBCBackendDataSource(this.dataSources);
    }

    public String getName() {
        return this.name;
    }

    public Map<String, DataSourceParameter> getDataSources() {
        return this.dataSources;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public JDBCBackendDataSource getBackendDataSource() {
        return this.backendDataSource;
    }
}

