/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.frontend;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import io.shardingsphere.shardingproxy.backend.BackendExecutorContext;
import io.shardingsphere.shardingproxy.backend.netty.client.BackendNettyClientManager;
import io.shardingsphere.shardingproxy.frontend.common.netty.ServerHandlerInitializer;
import io.shardingsphere.shardingproxy.runtime.GlobalRegistry;

public final class ShardingProxy {
    private static final ShardingProxy INSTANCE = new ShardingProxy();
    private static final GlobalRegistry GLOBAL_REGISTRY = GlobalRegistry.getInstance();
    private final BackendExecutorContext backendExecutorContext = BackendExecutorContext.getInstance();
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;

    public static ShardingProxy getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(int port) throws InterruptedException {
        try {
            ServerBootstrap bootstrap = new ServerBootstrap();
            this.bossGroup = this.createEventLoopGroup();
            if (this.bossGroup instanceof EpollEventLoopGroup) {
                this.groupsEpoll(bootstrap);
            } else {
                this.groupsNio(bootstrap);
            }
            ChannelFuture future = bootstrap.bind(port).sync();
            if (((Boolean)GLOBAL_REGISTRY.getShardingProperties().getValue(ShardingPropertiesConstant.PROXY_BACKEND_USE_NIO)).booleanValue()) {
                BackendNettyClientManager.getInstance().start(this.workerGroup);
            }
            future.channel().closeFuture().sync();
        }
        finally {
            this.workerGroup.shutdownGracefully();
            this.bossGroup.shutdownGracefully();
            this.backendExecutorContext.getExecuteEngine().close();
            if (((Boolean)GLOBAL_REGISTRY.getShardingProperties().getValue(ShardingPropertiesConstant.PROXY_BACKEND_USE_NIO)).booleanValue()) {
                BackendNettyClientManager.getInstance().stop();
            }
        }
    }

    private EventLoopGroup createEventLoopGroup() {
        try {
            return new EpollEventLoopGroup(1);
        }
        catch (UnsatisfiedLinkError ex) {
            return new NioEventLoopGroup(1);
        }
    }

    private void groupsEpoll(ServerBootstrap bootstrap) {
        this.workerGroup = new EpollEventLoopGroup();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(EpollServerSocketChannel.class)).option(EpollChannelOption.SO_BACKLOG, (Object)128)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(0x800000, 0x1000000))).option(EpollChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(EpollChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ServerHandlerInitializer());
    }

    private void groupsNio(ServerBootstrap bootstrap) {
        this.workerGroup = new NioEventLoopGroup();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)128)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)100)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(0x800000, 0x1000000))).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ServerHandlerInitializer());
    }

    private ShardingProxy() {
    }
}

