/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.netty.client;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.epoll.EpollChannelOption;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.pool.AbstractChannelPoolMap;
import io.netty.channel.pool.ChannelPoolHandler;
import io.netty.channel.pool.ChannelPoolMap;
import io.netty.channel.pool.FixedChannelPool;
import io.netty.channel.pool.SimpleChannelPool;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import io.shardingsphere.core.metadata.datasource.DataSourceMetaData;
import io.shardingsphere.shardingproxy.backend.netty.client.BackendNettyClientChannelPoolHandler;
import io.shardingsphere.shardingproxy.runtime.GlobalRegistry;
import io.shardingsphere.shardingproxy.runtime.schema.LogicSchema;
import java.beans.ConstructorProperties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BackendNettyClient {
    private static final Logger log = LoggerFactory.getLogger(BackendNettyClient.class);
    private static final int WORKER_MAX_THREADS = Runtime.getRuntime().availableProcessors();
    private static final GlobalRegistry GLOBAL_REGISTRY = GlobalRegistry.getInstance();
    private final LogicSchema logicSchema;
    private final int maxConnections;
    private final int connectionTimeoutSeconds;
    private final EventLoopGroup workerGroup;
    private ChannelPoolMap<String, SimpleChannelPool> poolMap;

    public BackendNettyClient(LogicSchema logicSchema, EventLoopGroup workerGroup) {
        this.logicSchema = logicSchema;
        this.maxConnections = (Integer)GLOBAL_REGISTRY.getShardingProperties().getValue(ShardingPropertiesConstant.PROXY_BACKEND_MAX_CONNECTIONS);
        this.connectionTimeoutSeconds = (Integer)GLOBAL_REGISTRY.getShardingProperties().getValue(ShardingPropertiesConstant.PROXY_BACKEND_CONNECTION_TIMEOUT_SECONDS);
        this.workerGroup = workerGroup;
    }

    public void start() throws InterruptedException {
        Bootstrap bootstrap = new Bootstrap();
        if (this.workerGroup instanceof EpollEventLoopGroup) {
            this.groupsEpoll(bootstrap);
        } else {
            this.groupsNio(bootstrap);
        }
        this.initPoolMap(bootstrap);
    }

    public void stop() {
        if (null != this.workerGroup) {
            this.workerGroup.shutdownGracefully();
        }
    }

    private void groupsEpoll(Bootstrap bootstrap) {
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.workerGroup)).channel(EpollSocketChannel.class)).option(EpollChannelOption.TCP_CORK, (Object)true)).option(EpollChannelOption.SO_KEEPALIVE, (Object)true)).option(EpollChannelOption.SO_BACKLOG, (Object)128)).option(EpollChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
    }

    private void groupsNio(Bootstrap bootstrap) {
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group(this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)100)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT);
    }

    private void initPoolMap(final Bootstrap bootstrap) throws InterruptedException {
        this.poolMap = new AbstractChannelPoolMap<String, SimpleChannelPool>(){

            protected SimpleChannelPool newPool(String dataSourceName) {
                DataSourceMetaData dataSourceMetaData = BackendNettyClient.this.logicSchema.getMetaData().getDataSource().getActualDataSourceMetaData(dataSourceName);
                return new FixedChannelPool(bootstrap.remoteAddress(dataSourceMetaData.getHostName(), dataSourceMetaData.getPort()), (ChannelPoolHandler)new BackendNettyClientChannelPoolHandler(dataSourceName, BackendNettyClient.this.logicSchema.getName()), BackendNettyClient.this.maxConnections);
            }
        };
        for (String each : this.logicSchema.getDataSources().keySet()) {
            int i;
            SimpleChannelPool pool = (SimpleChannelPool)this.poolMap.get((Object)each);
            Channel[] channels = new Channel[this.maxConnections];
            for (i = 0; i < this.maxConnections; ++i) {
                try {
                    channels[i] = (Channel)pool.acquire().get((long)this.connectionTimeoutSeconds, TimeUnit.SECONDS);
                    continue;
                }
                catch (ExecutionException | TimeoutException ex) {
                    log.error(ex.getMessage(), (Throwable)ex);
                }
            }
            for (i = 0; i < this.maxConnections; ++i) {
                pool.release(channels[i]);
            }
        }
    }

    @ConstructorProperties(value={"logicSchema", "maxConnections", "connectionTimeoutSeconds", "workerGroup"})
    public BackendNettyClient(LogicSchema logicSchema, int maxConnections, int connectionTimeoutSeconds, EventLoopGroup workerGroup) {
        this.logicSchema = logicSchema;
        this.maxConnections = maxConnections;
        this.connectionTimeoutSeconds = connectionTimeoutSeconds;
        this.workerGroup = workerGroup;
    }

    public ChannelPoolMap<String, SimpleChannelPool> getPoolMap() {
        return this.poolMap;
    }
}

