/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.jdbc.wrapper;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import io.shardingsphere.core.parsing.SQLJudgeEngine;
import io.shardingsphere.core.parsing.parser.sql.SQLStatement;
import io.shardingsphere.core.rewrite.MasterSlaveSQLRewriteEngine;
import io.shardingsphere.core.routing.PreparedStatementRoutingEngine;
import io.shardingsphere.core.routing.RouteUnit;
import io.shardingsphere.core.routing.SQLRouteResult;
import io.shardingsphere.core.routing.SQLUnit;
import io.shardingsphere.core.routing.router.masterslave.MasterSlaveRouter;
import io.shardingsphere.shardingproxy.backend.jdbc.wrapper.JDBCExecutorWrapper;
import io.shardingsphere.shardingproxy.runtime.GlobalRegistry;
import io.shardingsphere.shardingproxy.runtime.schema.LogicSchema;
import io.shardingsphere.shardingproxy.runtime.schema.MasterSlaveSchema;
import io.shardingsphere.shardingproxy.runtime.schema.ShardingSchema;
import java.beans.ConstructorProperties;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public final class PreparedStatementExecutorWrapper
implements JDBCExecutorWrapper {
    private static final GlobalRegistry GLOBAL_REGISTRY = GlobalRegistry.getInstance();
    private final LogicSchema logicSchema;
    private final List<Object> parameters;

    @Override
    public SQLRouteResult route(String sql, DatabaseType databaseType) {
        return this.logicSchema instanceof MasterSlaveSchema ? this.doMasterSlaveRoute(sql) : this.doShardingRoute(sql, databaseType);
    }

    private SQLRouteResult doMasterSlaveRoute(String sql) {
        SQLStatement sqlStatement = new SQLJudgeEngine(sql).judge();
        String rewriteSQL = new MasterSlaveSQLRewriteEngine(((MasterSlaveSchema)this.logicSchema).getMasterSlaveRule(), sql, sqlStatement, this.logicSchema.getMetaData()).rewrite();
        SQLRouteResult result = new SQLRouteResult(sqlStatement);
        for (String each : new MasterSlaveRouter(((MasterSlaveSchema)this.logicSchema).getMasterSlaveRule(), ((Boolean)GLOBAL_REGISTRY.getShardingProperties().getValue(ShardingPropertiesConstant.SQL_SHOW)).booleanValue()).route(rewriteSQL)) {
            result.getRouteUnits().add(new RouteUnit(each, new SQLUnit(rewriteSQL, new ArrayList<List<Object>>(Collections.singleton(this.parameters)))));
        }
        return result;
    }

    private SQLRouteResult doShardingRoute(String sql, DatabaseType databaseType) {
        return new PreparedStatementRoutingEngine(sql, ((ShardingSchema)this.logicSchema).getShardingRule(), this.logicSchema.getMetaData(), databaseType, ((Boolean)GLOBAL_REGISTRY.getShardingProperties().getValue(ShardingPropertiesConstant.SQL_SHOW)).booleanValue()).route(this.parameters);
    }

    @Override
    public Statement createStatement(Connection connection, SQLUnit sqlUnit, boolean isReturnGeneratedKeys) throws SQLException {
        PreparedStatement result = isReturnGeneratedKeys ? connection.prepareStatement(sqlUnit.getSql(), 1) : connection.prepareStatement(sqlUnit.getSql());
        List<Object> parameters = this.getRoutedParameters(sqlUnit);
        for (int i = 0; i < parameters.size(); ++i) {
            result.setObject(i + 1, parameters.get(i));
        }
        return result;
    }

    @Override
    public boolean executeSQL(Statement statement, String sql, boolean isReturnGeneratedKeys) throws SQLException {
        return ((PreparedStatement)statement).execute();
    }

    private List<Object> getRoutedParameters(SQLUnit sqlUnit) {
        LinkedList<Object> result = new LinkedList<Object>();
        for (List each : sqlUnit.getParameterSets()) {
            result.addAll(each);
        }
        return result;
    }

    @ConstructorProperties(value={"logicSchema", "parameters"})
    public PreparedStatementExecutorWrapper(LogicSchema logicSchema, List<Object> parameters) {
        this.logicSchema = logicSchema;
        this.parameters = parameters;
    }
}

