/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.jdbc.datasource;

import io.shardingsphere.core.constant.ConnectionMode;
import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.rule.DataSourceParameter;
import io.shardingsphere.core.util.ReflectiveUtil;
import io.shardingsphere.shardingproxy.backend.BackendDataSource;
import io.shardingsphere.shardingproxy.backend.jdbc.datasource.JDBCBackendDataSourceFactory;
import io.shardingsphere.shardingproxy.backend.jdbc.datasource.JDBCRawBackendDataSourceFactory;
import io.shardingsphere.shardingproxy.backend.jdbc.datasource.JDBCXABackendDataSourceFactory;
import io.shardingsphere.transaction.api.TransactionType;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JDBCBackendDataSource
implements BackendDataSource,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(JDBCBackendDataSource.class);
    private Map<String, DataSource> dataSources;
    private Map<String, DataSource> xaDataSources;
    private JDBCBackendDataSourceFactory hikariDataSourceFactory = JDBCRawBackendDataSourceFactory.getInstance();
    private JDBCBackendDataSourceFactory xaDataSourceFactory = JDBCXABackendDataSourceFactory.getInstance();

    public JDBCBackendDataSource(Map<String, DataSourceParameter> dataSourceParameters) {
        this.createDataSourceMap(dataSourceParameters);
    }

    private void createDataSourceMap(Map<String, DataSourceParameter> dataSourceParameters) {
        LinkedHashMap<String, DataSource> dataSourceMap = new LinkedHashMap<String, DataSource>(dataSourceParameters.size(), 1.0f);
        LinkedHashMap<String, DataSource> xaDataSourceMap = new LinkedHashMap<String, DataSource>(dataSourceParameters.size(), 1.0f);
        for (Map.Entry<String, DataSourceParameter> entry : dataSourceParameters.entrySet()) {
            try {
                dataSourceMap.put(entry.getKey(), this.hikariDataSourceFactory.build(entry.getKey(), entry.getValue()));
                xaDataSourceMap.put(entry.getKey(), this.xaDataSourceFactory.build(entry.getKey(), entry.getValue()));
            }
            catch (Exception ex) {
                throw new ShardingException(String.format("Can not build data source, name is `%s`.", entry.getKey()), ex);
            }
        }
        this.dataSources = dataSourceMap;
        this.xaDataSources = xaDataSourceMap;
    }

    public Connection getConnection(String dataSourceName) throws SQLException {
        return this.getConnections(ConnectionMode.MEMORY_STRICTLY, dataSourceName, 1).get(0);
    }

    public List<Connection> getConnections(ConnectionMode connectionMode, String dataSourceName, int connectionSize) throws SQLException {
        return this.getConnections(connectionMode, dataSourceName, connectionSize, TransactionType.LOCAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Connection> getConnections(ConnectionMode connectionMode, String dataSourceName, int connectionSize, TransactionType transactionType) throws SQLException {
        DataSource dataSource;
        DataSource dataSource2 = dataSource = TransactionType.XA == transactionType ? this.xaDataSources.get(dataSourceName) : this.dataSources.get(dataSourceName);
        if (1 == connectionSize) {
            return Collections.singletonList(dataSource.getConnection());
        }
        if (ConnectionMode.CONNECTION_STRICTLY == connectionMode) {
            return this.createConnections(dataSource, connectionSize);
        }
        DataSource dataSource3 = dataSource;
        synchronized (dataSource3) {
            return this.createConnections(dataSource, connectionSize);
        }
    }

    private List<Connection> createConnections(DataSource dataSource, int connectionSize) throws SQLException {
        ArrayList<Connection> result = new ArrayList<Connection>(connectionSize);
        for (int i = 0; i < connectionSize; ++i) {
            try {
                result.add(dataSource.getConnection());
                continue;
            }
            catch (SQLException ex) {
                for (Connection each : result) {
                    each.close();
                }
                throw new SQLException(String.format("Could't get %d connections one time, partition succeed connection(%d) have released!", connectionSize, result.size()), ex);
            }
        }
        return result;
    }

    @Override
    public void close() {
        if (null != this.dataSources) {
            this.closeDataSource(this.dataSources);
        }
        if (null != this.xaDataSources) {
            this.closeDataSource(this.xaDataSources);
        }
    }

    private void closeDataSource(Map<String, DataSource> dataSourceMap) {
        for (DataSource each : dataSourceMap.values()) {
            try {
                ReflectiveUtil.findMethod((Object)each, (String)"close", (Class[])new Class[0]).invoke((Object)each, new Object[0]);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {}
        }
    }

    public JDBCBackendDataSource() {
    }
}

