/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend.jdbc.connection;

import com.google.common.base.Preconditions;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import io.shardingsphere.core.constant.ConnectionMode;
import io.shardingsphere.core.exception.ShardingException;
import io.shardingsphere.core.routing.router.masterslave.MasterVisitedManager;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.ConnectionStateHandler;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.MethodInvocation;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.ResourceSynchronizer;
import io.shardingsphere.shardingproxy.runtime.GlobalRegistry;
import io.shardingsphere.shardingproxy.runtime.schema.LogicSchema;
import io.shardingsphere.transaction.api.TransactionType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BackendConnection
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(BackendConnection.class);
    private static final int MAXIMUM_RETRY_COUNT = 5;
    private volatile String schemaName;
    private LogicSchema logicSchema;
    private TransactionType transactionType;
    private int connectionId;
    private final Multimap<String, Connection> cachedConnections = LinkedHashMultimap.create();
    private final Collection<Statement> cachedStatements = new CopyOnWriteArrayList<Statement>();
    private final Collection<ResultSet> cachedResultSets = new CopyOnWriteArrayList<ResultSet>();
    private final Collection<MethodInvocation> methodInvocations = new ArrayList<MethodInvocation>();
    private final ResourceSynchronizer resourceSynchronizer = new ResourceSynchronizer();
    private final ConnectionStateHandler stateHandler = new ConnectionStateHandler(this.resourceSynchronizer);

    public BackendConnection(TransactionType transactionType) {
        this.transactionType = transactionType;
    }

    public void setTransactionType(TransactionType transactionType) {
        if (null == this.schemaName) {
            throw new ShardingException("Please select database, then switch transaction type.", new Object[0]);
        }
        if (this.isSwitchFailed()) {
            throw new ShardingException("Failed to switch transaction type, please terminate current transaction.", new Object[0]);
        }
        this.transactionType = transactionType;
    }

    public void setCurrentSchema(String schemaName) {
        if (this.isSwitchFailed()) {
            throw new ShardingException("Failed to switch schema, please terminate current transaction.", new Object[0]);
        }
        this.schemaName = schemaName;
        this.logicSchema = GlobalRegistry.getInstance().getLogicSchema(schemaName);
    }

    private boolean isSwitchFailed() {
        int retryCount = 0;
        while (this.stateHandler.isInTransaction() && retryCount < 5) {
            this.resourceSynchronizer.doAwait();
            log.warn("Current transaction have not terminated, retry count:[{}].", (Object)(++retryCount));
        }
        if (retryCount >= 5) {
            log.error("Cannot do switch, exceed maximum retry count:[{}].", (Object)5);
            return true;
        }
        return false;
    }

    public List<Connection> getConnections(ConnectionMode connectionMode, String dataSourceName, int connectionSize) throws SQLException {
        this.stateHandler.setRunningStatusIfNecessary();
        if (this.stateHandler.isInTransaction()) {
            return this.getConnectionsWithTransaction(connectionMode, dataSourceName, connectionSize);
        }
        return this.getConnectionsWithoutTransaction(connectionMode, dataSourceName, connectionSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Connection> getConnectionsWithTransaction(ConnectionMode connectionMode, String dataSourceName, int connectionSize) throws SQLException {
        List<Connection> result;
        Collection connections;
        Multimap<String, Connection> multimap = this.cachedConnections;
        synchronized (multimap) {
            connections = this.cachedConnections.get((Object)dataSourceName);
        }
        if (connections.size() >= connectionSize) {
            result = new ArrayList(connections).subList(0, connectionSize);
        } else {
            if (!connections.isEmpty()) {
                result = new ArrayList(connectionSize);
                result.addAll(connections);
                List<Connection> newConnections = this.createNewConnections(connectionMode, dataSourceName, connectionSize - connections.size());
                result.addAll(newConnections);
                Multimap<String, Connection> multimap2 = this.cachedConnections;
                synchronized (multimap2) {
                    this.cachedConnections.putAll((Object)dataSourceName, newConnections);
                }
            }
            result = this.createNewConnections(connectionMode, dataSourceName, connectionSize);
            Multimap<String, Connection> multimap3 = this.cachedConnections;
            synchronized (multimap3) {
                this.cachedConnections.putAll((Object)dataSourceName, result);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Connection> getConnectionsWithoutTransaction(ConnectionMode connectionMode, String dataSourceName, int connectionSize) throws SQLException {
        Preconditions.checkNotNull((Object)this.logicSchema, (Object)"current logic schema is null");
        List<Connection> result = this.getConnectionFromUnderlying(connectionMode, dataSourceName, connectionSize);
        Multimap<String, Connection> multimap = this.cachedConnections;
        synchronized (multimap) {
            this.cachedConnections.putAll((Object)dataSourceName, result);
        }
        return result;
    }

    private List<Connection> createNewConnections(ConnectionMode connectionMode, String dataSourceName, int connectionSize) throws SQLException {
        Preconditions.checkNotNull((Object)this.logicSchema, (Object)"current logic schema is null");
        List<Connection> result = this.getConnectionFromUnderlying(connectionMode, dataSourceName, connectionSize);
        for (Connection each : result) {
            this.replayMethodsInvocation(each);
        }
        return result;
    }

    private List<Connection> getConnectionFromUnderlying(ConnectionMode connectionMode, String dataSourceName, int connectionSize) throws SQLException {
        return TransactionType.XA == this.transactionType ? this.logicSchema.getBackendDataSource().getConnections(connectionMode, dataSourceName, connectionSize, TransactionType.XA) : this.logicSchema.getBackendDataSource().getConnections(connectionMode, dataSourceName, connectionSize);
    }

    public int getConnectionSize() {
        return this.cachedConnections.values().size();
    }

    public void add(Statement statement) {
        this.cachedStatements.add(statement);
    }

    public void add(ResultSet resultSet) {
        this.cachedResultSets.add(resultSet);
    }

    @Override
    public void close() throws SQLException {
        this.close(false);
    }

    public synchronized void close(boolean forceClose) throws SQLException {
        LinkedList<SQLException> exceptions = new LinkedList<SQLException>();
        MasterVisitedManager.clear();
        exceptions.addAll(this.closeStatements());
        exceptions.addAll(this.closeResultSets());
        if (!this.stateHandler.isInTransaction() || forceClose) {
            exceptions.addAll(this.releaseConnections(forceClose));
        }
        this.stateHandler.doNotifyIfNecessary();
        this.throwSQLExceptionIfNecessary(exceptions);
    }

    private Collection<SQLException> closeResultSets() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (ResultSet each : this.cachedResultSets) {
            try {
                each.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        this.cachedResultSets.clear();
        return result;
    }

    private Collection<SQLException> closeStatements() {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Statement each : this.cachedStatements) {
            try {
                each.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        this.cachedStatements.clear();
        return result;
    }

    Collection<SQLException> releaseConnections(boolean forceRollback) {
        LinkedList<SQLException> result = new LinkedList<SQLException>();
        for (Connection each : this.cachedConnections.values()) {
            try {
                if (forceRollback && this.stateHandler.isInTransaction()) {
                    each.rollback();
                }
                each.close();
            }
            catch (SQLException ex) {
                result.add(ex);
            }
        }
        this.cachedConnections.clear();
        this.methodInvocations.clear();
        return result;
    }

    private void throwSQLExceptionIfNecessary(Collection<SQLException> exceptions) throws SQLException {
        if (exceptions.isEmpty()) {
            return;
        }
        SQLException ex = new SQLException();
        for (SQLException each : exceptions) {
            ex.setNextException(each);
        }
        throw ex;
    }

    private void replayMethodsInvocation(Object target) {
        for (MethodInvocation each : this.methodInvocations) {
            each.invoke(target);
        }
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public LogicSchema getLogicSchema() {
        return this.logicSchema;
    }

    public TransactionType getTransactionType() {
        return this.transactionType;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    public Multimap<String, Connection> getCachedConnections() {
        return this.cachedConnections;
    }

    public Collection<Statement> getCachedStatements() {
        return this.cachedStatements;
    }

    public Collection<ResultSet> getCachedResultSets() {
        return this.cachedResultSets;
    }

    public Collection<MethodInvocation> getMethodInvocations() {
        return this.methodInvocations;
    }

    public ResourceSynchronizer getResourceSynchronizer() {
        return this.resourceSynchronizer;
    }

    public ConnectionStateHandler getStateHandler() {
        return this.stateHandler;
    }

    public void setConnectionId(int connectionId) {
        this.connectionId = connectionId;
    }
}

