/*
 * Decompiled with CFR 0.152.
 */
package io.shardingsphere.shardingproxy.backend;

import io.shardingsphere.core.constant.DatabaseType;
import io.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import io.shardingsphere.shardingproxy.backend.BackendHandler;
import io.shardingsphere.shardingproxy.backend.jdbc.JDBCBackendHandler;
import io.shardingsphere.shardingproxy.backend.jdbc.connection.BackendConnection;
import io.shardingsphere.shardingproxy.backend.jdbc.execute.JDBCExecuteEngine;
import io.shardingsphere.shardingproxy.backend.jdbc.wrapper.PreparedStatementExecutorWrapper;
import io.shardingsphere.shardingproxy.backend.jdbc.wrapper.StatementExecutorWrapper;
import io.shardingsphere.shardingproxy.backend.netty.NettyBackendHandler;
import io.shardingsphere.shardingproxy.runtime.GlobalRegistry;
import io.shardingsphere.shardingproxy.runtime.schema.LogicSchema;
import java.util.List;

public final class BackendHandlerFactory {
    private static final BackendHandlerFactory INSTANCE = new BackendHandlerFactory();
    private static final GlobalRegistry GLOBAL_REGISTRY = GlobalRegistry.getInstance();

    public static BackendHandlerFactory getInstance() {
        return INSTANCE;
    }

    public BackendHandler newTextProtocolInstance(int sequenceId, String sql, BackendConnection backendConnection, DatabaseType databaseType) {
        LogicSchema logicSchema = backendConnection.getLogicSchema();
        return (Boolean)GLOBAL_REGISTRY.getShardingProperties().getValue(ShardingPropertiesConstant.PROXY_BACKEND_USE_NIO) != false ? new NettyBackendHandler(logicSchema, backendConnection.getConnectionId(), sequenceId, sql, databaseType) : new JDBCBackendHandler(logicSchema, sql, new JDBCExecuteEngine(backendConnection, new StatementExecutorWrapper(logicSchema)));
    }

    public BackendHandler newBinaryProtocolInstance(int sequenceId, String sql, List<Object> parameters, BackendConnection backendConnection, DatabaseType databaseType) {
        LogicSchema logicSchema = backendConnection.getLogicSchema();
        return (Boolean)GLOBAL_REGISTRY.getShardingProperties().getValue(ShardingPropertiesConstant.PROXY_BACKEND_USE_NIO) != false ? new NettyBackendHandler(logicSchema, backendConnection.getConnectionId(), sequenceId, sql, databaseType) : new JDBCBackendHandler(logicSchema, sql, new JDBCExecuteEngine(backendConnection, new PreparedStatementExecutorWrapper(logicSchema, parameters)));
    }

    private BackendHandlerFactory() {
    }
}

