/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.registry;

import com.google.common.eventbus.EventBus;
import io.servicecomb.serviceregistry.Features;
import io.servicecomb.serviceregistry.ServiceRegistry;
import io.servicecomb.serviceregistry.api.registry.BasePath;
import io.servicecomb.serviceregistry.api.registry.Microservice;
import io.servicecomb.serviceregistry.api.registry.MicroserviceFactory;
import io.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import io.servicecomb.serviceregistry.cache.InstanceCacheManager;
import io.servicecomb.serviceregistry.cache.InstanceCacheManagerNew;
import io.servicecomb.serviceregistry.cache.InstanceCacheManagerOld;
import io.servicecomb.serviceregistry.client.IpPortManager;
import io.servicecomb.serviceregistry.client.ServiceRegistryClient;
import io.servicecomb.serviceregistry.config.ServiceRegistryConfig;
import io.servicecomb.serviceregistry.consumer.AppManager;
import io.servicecomb.serviceregistry.consumer.MicroserviceVersionFactory;
import io.servicecomb.serviceregistry.definition.MicroserviceDefinition;
import io.servicecomb.serviceregistry.task.MicroserviceServiceCenterTask;
import io.servicecomb.serviceregistry.task.ServiceCenterTask;
import io.servicecomb.serviceregistry.task.event.ShutdownEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceRegistry
implements ServiceRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractServiceRegistry.class);
    private Features features = new Features();
    private MicroserviceFactory microserviceFactory = new MicroserviceFactory();
    protected EventBus eventBus;
    protected MicroserviceDefinition microserviceDefinition;
    protected Microservice microservice;
    protected AppManager appManager;
    protected InstanceCacheManager instanceCacheManager;
    protected IpPortManager ipPortManager;
    protected ServiceRegistryClient srClient;
    protected ServiceRegistryConfig serviceRegistryConfig;
    protected ServiceCenterTask serviceCenterTask;

    public AbstractServiceRegistry(EventBus eventBus, ServiceRegistryConfig serviceRegistryConfig, MicroserviceDefinition microserviceDefinition) {
        this.eventBus = eventBus;
        this.serviceRegistryConfig = serviceRegistryConfig;
        this.microserviceDefinition = microserviceDefinition;
        this.microservice = this.microserviceFactory.create(microserviceDefinition);
    }

    @Override
    public void init() {
        try {
            this.initAppManager();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Failed to init appManager.", e);
        }
        this.initCacheManager();
        this.ipPortManager = new IpPortManager(this.serviceRegistryConfig, this.instanceCacheManager);
        if (this.srClient == null) {
            this.srClient = this.createServiceRegistryClient();
        }
        this.createServiceCenterTask();
        this.eventBus.register((Object)this);
    }

    protected void initAppManager() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.appManager = new AppManager(this.eventBus);
        String microserviceVersionFactoryClass = this.serviceRegistryConfig.getMicroserviceVersionFactory();
        if (microserviceVersionFactoryClass == null) {
            return;
        }
        MicroserviceVersionFactory microserviceVersionFactory = (MicroserviceVersionFactory)Class.forName(microserviceVersionFactoryClass).newInstance();
        this.appManager.setMicroserviceVersionFactory(microserviceVersionFactory);
        LOGGER.info("microserviceVersionFactory is {}.", (Object)microserviceVersionFactoryClass);
    }

    protected void initCacheManager() {
        String microserviceVersionFactoryClass = this.serviceRegistryConfig.getMicroserviceVersionFactory();
        if (microserviceVersionFactoryClass == null) {
            this.instanceCacheManager = new InstanceCacheManagerOld(this.eventBus, this, this.serviceRegistryConfig);
            return;
        }
        this.instanceCacheManager = new InstanceCacheManagerNew(this.appManager);
    }

    @Override
    public AppManager getAppManager() {
        return this.appManager;
    }

    @Override
    public Features getFeatures() {
        return this.features;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    @Override
    public Set<String> getCombinedMicroserviceNames() {
        return this.microserviceDefinition.getCombinedFrom();
    }

    @Override
    public ServiceRegistryClient getServiceRegistryClient() {
        return this.srClient;
    }

    public void setServiceRegistryClient(ServiceRegistryClient serviceRegistryClient) {
        this.srClient = serviceRegistryClient;
    }

    public IpPortManager getIpPortManager() {
        return this.ipPortManager;
    }

    @Override
    public InstanceCacheManager getInstanceCacheManager() {
        return this.instanceCacheManager;
    }

    protected abstract ServiceRegistryClient createServiceRegistryClient();

    @Override
    public void run() {
        this.loadStaticConfiguration();
        this.serviceCenterTask.init();
    }

    private void loadStaticConfiguration() {
        List<BasePath> paths = this.microservice.getPaths();
        for (BasePath path : paths) {
            if (path.getProperty() == null) {
                path.setProperty(new HashMap<String, String>());
            }
            path.getProperty().put("checksession", "false");
        }
    }

    private void createServiceCenterTask() {
        MicroserviceServiceCenterTask task = new MicroserviceServiceCenterTask(this.eventBus, this.serviceRegistryConfig, this.srClient, this.microservice);
        this.serviceCenterTask = new ServiceCenterTask(this.eventBus, this.serviceRegistryConfig.getHeartbeatInterval(), task);
    }

    public boolean unregisterInstance() {
        MicroserviceInstance microserviceInstance = this.microservice.getIntance();
        boolean result = this.srClient.unregisterMicroserviceInstance(microserviceInstance.getServiceId(), microserviceInstance.getInstanceId());
        if (!result) {
            LOGGER.error("Unregister microservice instance failed. microserviceId={} instanceId={}", (Object)microserviceInstance.getServiceId(), (Object)microserviceInstance.getInstanceId());
            return false;
        }
        LOGGER.info("Unregister microservice instance success. microserviceId={} instanceId={}", (Object)microserviceInstance.getServiceId(), (Object)microserviceInstance.getInstanceId());
        return true;
    }

    @Override
    public List<MicroserviceInstance> findServiceInstance(String appId, String serviceName, String versionRule) {
        List<MicroserviceInstance> instances = this.srClient.findServiceInstance(this.microservice.getServiceId(), appId, serviceName, versionRule);
        if (instances == null) {
            LOGGER.error("find empty instances from service center. service={}/{}/{}", new Object[]{appId, serviceName, versionRule});
            return null;
        }
        LOGGER.info("find instances[{}] from service center success. service={}/{}/{}", new Object[]{instances.size(), appId, serviceName, versionRule});
        for (MicroserviceInstance instance : instances) {
            LOGGER.info("service id={}, instance id={}, endpoints={}", new Object[]{instance.getServiceId(), instance.getInstanceId(), instance.getEndpoints()});
        }
        return instances;
    }

    @Override
    public boolean updateMicroserviceProperties(Map<String, String> properties) {
        boolean success = this.srClient.updateMicroserviceProperties(this.microservice.getServiceId(), properties);
        if (success) {
            this.microservice.setProperties(properties);
        }
        return success;
    }

    @Override
    public boolean updateInstanceProperties(Map<String, String> instanceProperties) {
        MicroserviceInstance microserviceInstance = this.microservice.getIntance();
        boolean success = this.srClient.updateInstanceProperties(microserviceInstance.getServiceId(), microserviceInstance.getInstanceId(), instanceProperties);
        if (success) {
            microserviceInstance.setProperties(instanceProperties);
        }
        return success;
    }

    @Override
    public Microservice getRemoteMicroservice(String microserviceId) {
        return this.srClient.getMicroservice(microserviceId);
    }

    @Override
    public Microservice getMicroservice() {
        return this.microservice;
    }

    @Override
    public MicroserviceInstance getMicroserviceInstance() {
        return this.microservice.getIntance();
    }

    @Override
    public void destroy() {
        this.eventBus.post((Object)new ShutdownEvent());
        this.unregisterInstance();
    }
}

