/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.consumer;

import com.google.common.eventbus.EventBus;
import io.servicecomb.serviceregistry.consumer.DefaultMicroserviceVersionFactory;
import io.servicecomb.serviceregistry.consumer.MicroserviceManager;
import io.servicecomb.serviceregistry.consumer.MicroserviceVersionFactory;
import io.servicecomb.serviceregistry.consumer.MicroserviceVersionRule;
import io.servicecomb.serviceregistry.consumer.MicroserviceVersions;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AppManager {
    private EventBus eventBus;
    private MicroserviceVersionFactory microserviceVersionFactory = new DefaultMicroserviceVersionFactory();
    private Map<String, MicroserviceManager> apps = new ConcurrentHashMap<String, MicroserviceManager>();

    public AppManager(EventBus eventBus) {
        this.eventBus = eventBus;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    public MicroserviceVersionFactory getMicroserviceVersionFactory() {
        return this.microserviceVersionFactory;
    }

    public void setMicroserviceVersionFactory(MicroserviceVersionFactory microserviceVersionFactory) {
        this.microserviceVersionFactory = microserviceVersionFactory;
    }

    public MicroserviceVersionRule getOrCreateMicroserviceVersionRule(String appId, String microserviceName, String versionRule) {
        MicroserviceManager microserviceManager = this.getOrCreateMicroserviceManager(appId);
        return microserviceManager.getOrCreateMicroserviceVersionRule(microserviceName, versionRule);
    }

    public MicroserviceManager getOrCreateMicroserviceManager(String appId) {
        return this.apps.computeIfAbsent(appId, id -> new MicroserviceManager(this, appId));
    }

    public MicroserviceVersions getOrCreateMicroserviceVersions(String appId, String microserviceName) {
        MicroserviceManager microserviceManager = this.getOrCreateMicroserviceManager(appId);
        return microserviceManager.getOrCreateMicroserviceVersions(microserviceName);
    }
}

