/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.serviceregistry.api.registry;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import io.servicecomb.serviceregistry.api.registry.BasePath;
import io.servicecomb.serviceregistry.api.registry.MicroserviceInstance;
import io.servicecomb.serviceregistry.api.registry.MicroserviceStatus;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Microservice {
    private String serviceId;
    private String appId;
    private String serviceName;
    private String alias;
    private String version;
    private String description;
    private String level;
    private List<String> schemas = new ArrayList<String>();
    @JsonIgnore
    private Map<String, String> schemaMap = new HashMap<String, String>();
    private List<BasePath> paths = new ArrayList<BasePath>();
    private MicroserviceStatus status = MicroserviceStatus.UP;
    private Map<String, String> properties = new HashMap<String, String>();
    @JsonIgnore
    private MicroserviceInstance intance;

    public MicroserviceInstance getIntance() {
        return this.intance;
    }

    public void setIntance(MicroserviceInstance intance) {
        this.intance = intance;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getLevel() {
        return this.level;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public List<String> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<String> schemas) {
        this.schemas = schemas;
    }

    public void addSchema(String schemaId, String content) {
        this.schemaMap.put(schemaId, content);
        this.schemas.add(schemaId);
    }

    public Map<String, String> getSchemaMap() {
        return this.schemaMap;
    }

    public String getStatus() {
        return this.status.toString();
    }

    public void setStatus(String status) {
        this.status = MicroserviceStatus.valueOf(status);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public static String generateAbsoluteMicroserviceName(String appId, String microserviceName) {
        StringBuilder sb = new StringBuilder(appId.length() + microserviceName.length() + 1);
        sb.append(appId).append(":").append(microserviceName);
        return sb.toString();
    }

    public List<BasePath> getPaths() {
        return this.paths;
    }

    public void setPaths(List<BasePath> paths) {
        this.paths = paths;
    }
}

