/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.foundation.vertx.client.tcp;

import io.servicecomb.foundation.vertx.client.tcp.AbstractTcpClientPackage;
import io.servicecomb.foundation.vertx.client.tcp.TcpClientConfig;
import io.servicecomb.foundation.vertx.client.tcp.TcpClientConnection;
import io.servicecomb.foundation.vertx.client.tcp.TcpResponseCallback;
import io.vertx.core.Context;
import io.vertx.core.net.NetClient;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractTcpClientConnectionPool<T extends TcpClientConnection> {
    protected Context context;
    protected TcpClientConfig clientConfig;
    protected NetClient netClient;
    protected Map<String, T> tcpClientMap = new ConcurrentHashMap<String, T>();

    public AbstractTcpClientConnectionPool(TcpClientConfig clientConfig, Context context, NetClient netClient) {
        this.clientConfig = clientConfig;
        this.context = context;
        this.netClient = netClient;
        this.startCheckTimeout(clientConfig, context);
    }

    protected void startCheckTimeout(TcpClientConfig clientConfig, Context context) {
        context.owner().setPeriodic(clientConfig.getRequestTimeoutMillis(), this::onCheckTimeout);
    }

    private void onCheckTimeout(Long event) {
        for (TcpClientConnection client : this.tcpClientMap.values()) {
            client.checkTimeout();
        }
    }

    public void send(TcpClientConnection tcpClient, AbstractTcpClientPackage tcpClientPackage, TcpResponseCallback callback) {
        tcpClient.send(tcpClientPackage, this.clientConfig.getRequestTimeoutMillis(), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T findOrCreateClient(String endpoint) {
        TcpClientConnection tcpClient = (TcpClientConnection)this.tcpClientMap.get(endpoint);
        if (tcpClient == null) {
            AbstractTcpClientConnectionPool abstractTcpClientConnectionPool = this;
            synchronized (abstractTcpClientConnectionPool) {
                tcpClient = (TcpClientConnection)this.tcpClientMap.get(endpoint);
                if (tcpClient == null) {
                    tcpClient = this.create(endpoint);
                    this.tcpClientMap.put(endpoint, tcpClient);
                }
            }
        }
        return (T)tcpClient;
    }

    protected abstract T create(String var1);
}

