/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.foundation.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.springframework.util.ReflectionUtils;

public final class ReflectUtils {
    private static final Field MODIFIERS_FIELD = ReflectionUtils.findField(Field.class, (String)"modifiers");

    private ReflectUtils() {
    }

    public static void setField(Object instance, String fieldName, Object value) {
        ReflectUtils.setField(instance.getClass(), instance, fieldName, value);
    }

    public static void setField(Class<?> cls, Object instance, String fieldName, Object value) {
        Field field = ReflectionUtils.findField(cls, (String)fieldName);
        try {
            if ((field.getModifiers() & 0x10) != 0) {
                MODIFIERS_FIELD.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            }
            field.setAccessible(true);
            field.set(instance, value);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public static Method findMethod(Class<?> cls, String methodName) {
        for (Method method : cls.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    static {
        MODIFIERS_FIELD.setAccessible(true);
    }
}

