/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.foundation.common.utils;

import io.servicecomb.foundation.common.utils.RSAKeyPairEntry;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RSAUtils.class);
    private static final String RSA_ALG = "RSA";
    private static final String SIGN_ALG = "SHA256withRSA";
    private static final int KEY_SIZE = 2048;
    private static Base64.Encoder encoder = Base64.getEncoder();
    private static Base64.Decoder decoder = Base64.getDecoder();
    private static KeyFactory kf = null;

    public static RSAKeyPairEntry generateRSAKeyPair() {
        try {
            KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance(RSA_ALG);
            keyGenerator.initialize(2048, new SecureRandom());
            KeyPair keyPair = keyGenerator.generateKeyPair();
            PublicKey pubKey = keyPair.getPublic();
            PrivateKey privKey = keyPair.getPrivate();
            return new RSAKeyPairEntry(privKey, pubKey, encoder.encodeToString(pubKey.getEncoded()));
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("generate rsa keypair faild");
            throw new IllegalStateException("perhaps error occurred on jre");
        }
    }

    public static String sign(String content, PrivateKey privateKey) throws NoSuchAlgorithmException, InvalidKeySpecException, SignatureException, InvalidKeyException {
        Signature signature = Signature.getInstance(SIGN_ALG);
        signature.initSign(privateKey);
        signature.update(content.getBytes());
        byte[] signByte = signature.sign();
        return encoder.encodeToString(signByte);
    }

    public static boolean verify(String publicKey, String sign, String content) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        if (null == kf) {
            throw new NoSuchAlgorithmException("RSA KeyFactory not available");
        }
        byte[] bytes = decoder.decode(publicKey);
        X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
        PublicKey pubKey = kf.generatePublic(keySpec);
        Signature signature = Signature.getInstance(SIGN_ALG);
        signature.initVerify(pubKey);
        signature.update(content.getBytes());
        return signature.verify(decoder.decode(sign));
    }

    static {
        try {
            kf = KeyFactory.getInstance(RSA_ALG);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("init keyfactory error");
        }
    }
}

