/*
 * Decompiled with CFR 0.152.
 */
package io.servicecomb.foundation.common;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractObjectManager<KEY_OWNER, KEY, VALUE> {
    protected Map<KEY, VALUE> objMap = new ConcurrentHashMap<KEY, VALUE>();
    protected final Object lockObj = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VALUE getOrCreate(KEY_OWNER keyOwner) {
        KEY key = this.getKey(keyOwner);
        VALUE value = this.objMap.get(key);
        if (value == null) {
            Object object = this.lockObj;
            synchronized (object) {
                value = this.objMap.get(key);
                if (value == null) {
                    value = this.create(keyOwner);
                    if (value == null) {
                        return null;
                    }
                    this.objMap.put(key, value);
                }
            }
        }
        return value;
    }

    public VALUE findByKey(KEY key) {
        return this.objMap.get(key);
    }

    public VALUE findByContainer(KEY_OWNER keyOwner) {
        KEY key = this.getKey(keyOwner);
        return this.objMap.get(key);
    }

    public Set<KEY> keys() {
        return this.objMap.keySet();
    }

    public Collection<VALUE> values() {
        return this.objMap.values();
    }

    protected abstract KEY getKey(KEY_OWNER var1);

    protected abstract VALUE create(KEY_OWNER var1);
}

