/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.utils;

import com.qingstor.sdk.constants.QSConstant;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.utils.QSJSONUtil;
import com.qingstor.sdk.utils.QSParamInvokeUtil;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class QSStringUtil {
    public static String objectToJson(String key, Object o) throws QSException {
        return "{ \"" + key + "\":" + QSStringUtil.objectJSONKeyValue(key, o) + "}";
    }

    private static String objectJSONKeyValue(String key, Object o) throws QSException {
        return " \"" + key + "\":" + QSStringUtil.objectJSONValue(o);
    }

    public static Object objectJSONValue(Object o) throws QSException {
        if (o instanceof List) {
            List lst = (List)o;
            JSONArray jsonArray = new JSONArray();
            for (int i = 0; i < lst.size(); ++i) {
                QSJSONUtil.putJsonData(jsonArray, i, QSStringUtil.objectJSONValue(lst.get(i)));
            }
            return jsonArray;
        }
        if (o instanceof Integer || o instanceof Double || o instanceof Boolean || o instanceof Long || o instanceof Float || o instanceof String) {
            return o;
        }
        if (o instanceof Map) {
            return QSStringUtil.getMapToJson((Map)o);
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        QSParamInvokeUtil.invokeObject2Map(o.getClass(), o, params);
        return QSStringUtil.getMapToJson(params);
    }

    public static JSONObject getMapToJson(Map o) throws QSException {
        JSONObject json = new JSONObject();
        try {
            Iterator iterator = o.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry value;
                Map.Entry entry = value = iterator.next();
                String key = (String)entry.getKey();
                Object bodyObj = o.get(key);
                json.put(key, QSStringUtil.objectJSONValue(bodyObj));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            throw new QSException("ObjectToJson", e);
        }
        return json;
    }

    public static String getObjectToJson(Object o) {
        JSONObject json = null;
        if (o instanceof Map) {
            json = new JSONObject();
            Iterator iterator = ((Map)o).entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry value;
                Map.Entry entry = value = iterator.next();
                String key = (String)entry.getKey();
                Object bodyObj = ((Map)o).get(key);
                json.put(key, bodyObj);
            }
        } else {
            json = new JSONObject(o);
        }
        return json.toString();
    }

    @Deprecated
    public static String percentEncode(String value, String encoding) throws UnsupportedEncodingException {
        return value != null ? URLEncoder.encode(value, encoding).replace("+", "%20").replace("*", "%2A").replace("%7E", "~") : null;
    }

    public static boolean isEmpty(String str) {
        return str == null || "".equals(str.trim()) || "null".equalsIgnoreCase(str);
    }

    public static String getUserAgent() {
        return QSConstant.SDK_NAME + "/" + QSConstant.SDK_VERSION + " ( java v" + System.getProperty("java.version") + ";" + System.getProperty("os.name") + ")";
    }

    public static String getParameterRequired(String paraName, String value) {
        return String.format("%s is required in %s ", paraName, value);
    }

    public static String getParameterValueNotAllowedError(String paraName, String value, String[] values) {
        StringBuilder buf = new StringBuilder();
        for (String o : values) {
            buf.append(o.toString()).append(",");
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 1);
        }
        return String.format("%s value %s is not allowed, should be one of %s ", paraName, value, buf.toString());
    }

    public static String asciiCharactersEncoding(String str) {
        if (QSStringUtil.isEmpty(str)) {
            return "";
        }
        try {
            String encoded = URLEncoder.encode(str, "UTF-8");
            return encoded.replace("%2F", "/").replace("%3D", "=").replace("+", "%20").replace("%3A", ":");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static String capitalize(String word) {
        return word.substring(0, 1).toUpperCase() + word.substring(1);
    }
}

