/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.request.impl;

import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.request.QSRequestBody;
import com.qingstor.sdk.request.impl.EmptyRequestBody;
import com.qingstor.sdk.request.impl.InputStreamUploadBody;
import com.qingstor.sdk.utils.QSStringUtil;
import java.io.File;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.internal.http.HttpMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QSFormRequestBody
implements QSRequestBody {
    private static final Logger log = LoggerFactory.getLogger(QSFormRequestBody.class);

    @Override
    public RequestBody getRequestBody(String contentType, long contentLength, String method, Map<String, Object> bodyParams, Map<String, Object> queryParams) throws QSException {
        log.debug("----QSFormRequestBody----");
        MediaType mediaType = MediaType.parse((String)contentType);
        if (bodyParams != null && bodyParams.size() > 0) {
            Iterator<Map.Entry<String, Object>> iterator = bodyParams.entrySet().iterator();
            if (this.checkHasFileBody(bodyParams)) {
                MultipartBody.Builder requestBody = new MultipartBody.Builder().setType(MultipartBody.FORM);
                String fileKey = "";
                File file = null;
                while (iterator.hasNext()) {
                    Map.Entry<String, Object> entry = iterator.next();
                    String key = entry.getKey();
                    Object bodyObj = bodyParams.get(key);
                    if (bodyObj instanceof File) {
                        fileKey = key;
                        file = (File)bodyObj;
                        continue;
                    }
                    if (bodyObj instanceof InputStream) {
                        requestBody.addFormDataPart("form-data", key, (RequestBody)new InputStreamUploadBody(contentType, (InputStream)bodyObj, contentLength));
                        continue;
                    }
                    if (bodyObj instanceof Map) {
                        requestBody.addFormDataPart(key, QSStringUtil.getMapToJson((Map)bodyObj).toString());
                        continue;
                    }
                    Object json = QSStringUtil.objectJSONValue(bodyObj);
                    requestBody.addFormDataPart(key, String.valueOf(json));
                }
                if (file != null) {
                    requestBody.addFormDataPart(fileKey, file.getName(), RequestBody.create((MediaType)mediaType, (File)file));
                }
                return requestBody.build();
            }
            FormBody.Builder requestFormBody = new FormBody.Builder();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String key = entry.getKey();
                Object bodyObj = bodyParams.get(key);
                Object json = QSStringUtil.objectJSONValue(bodyObj);
                requestFormBody.add(key, String.valueOf(json));
            }
            return requestFormBody.build();
        }
        if (HttpMethod.permitsRequestBody((String)method)) {
            return new EmptyRequestBody(contentType);
        }
        return null;
    }

    private boolean checkHasFileBody(Map formParams) {
        boolean hasFile = false;
        for (Map.Entry o : formParams.entrySet()) {
            Map.Entry entry = o;
            String key = (String)entry.getKey();
            Object bodyObj = formParams.get(key);
            if (bodyObj instanceof File) {
                hasFile = true;
                continue;
            }
            if (!(bodyObj instanceof InputStream)) continue;
            hasFile = true;
        }
        return hasFile;
    }
}

