/*
 * Decompiled with CFR 0.152.
 */
package com.qingstor.sdk.request;

import com.qingstor.sdk.common.OperationContext;
import com.qingstor.sdk.config.EnvContext;
import com.qingstor.sdk.exception.QSException;
import com.qingstor.sdk.model.OutputModel;
import com.qingstor.sdk.model.RequestInputModel;
import com.qingstor.sdk.request.QSOkHttpRequestClient;
import com.qingstor.sdk.request.RequestHandler;
import com.qingstor.sdk.request.ResourceRequest;
import com.qingstor.sdk.request.ResponseCallBack;
import java.util.Map;
import okhttp3.Request;

public class QSRequest
implements ResourceRequest {
    public static void sendApiRequestAsync(String requestUrl, OperationContext opCtx, ResponseCallBack callback) {
        EnvContext envContext = (EnvContext)opCtx.credentials();
        Request request = new Request.Builder().url(requestUrl).build();
        QSOkHttpRequestClient.getInstance(envContext).requestActionAsync(request, envContext.isSafeOkHttp(), callback);
    }

    public static OutputModel sendApiRequest(String requestUrl, OperationContext opCtx, Class<? extends OutputModel> outputClass) throws QSException {
        EnvContext envContext = (EnvContext)opCtx.credentials();
        Request request = new Request.Builder().url(requestUrl).build();
        return QSOkHttpRequestClient.getInstance(envContext).requestAction(request, envContext.isSafeOkHttp(), outputClass);
    }

    public static RequestHandler getRequestAsync(OperationContext opCtx, RequestInputModel paramBean, ResponseCallBack callback) throws QSException {
        return new RequestHandler(opCtx, paramBean, (ResponseCallBack<? extends OutputModel>)callback);
    }

    public static RequestHandler getRequest(OperationContext opCtx, RequestInputModel paramBean, Class<? extends OutputModel> outputClass) throws QSException {
        return new RequestHandler(opCtx, paramBean, outputClass);
    }

    @Override
    @Deprecated
    public void sendApiRequestAsync(String requestUrl, Map context, ResponseCallBack callback) throws QSException {
        EnvContext envContext = (EnvContext)context.get("envContext");
        Request request = new Request.Builder().url(requestUrl).build();
        QSOkHttpRequestClient.getInstance(envContext).requestActionAsync(request, envContext.isSafeOkHttp(), callback);
    }

    @Override
    @Deprecated
    public OutputModel sendApiRequest(String requestUrl, Map context, Class<? extends OutputModel> outputClass) throws QSException {
        EnvContext envContext = (EnvContext)context.get("envContext");
        Request request = new Request.Builder().url(requestUrl).build();
        return QSOkHttpRequestClient.getInstance(envContext).requestAction(request, envContext.isSafeOkHttp(), outputClass);
    }

    @Override
    @Deprecated
    public RequestHandler getRequestAsync(Map context, RequestInputModel paramBean, ResponseCallBack callback) throws QSException {
        return new RequestHandler((Map<String, Object>)context, paramBean, (ResponseCallBack<? extends OutputModel>)callback);
    }

    @Override
    @Deprecated
    public RequestHandler getRequest(Map context, RequestInputModel paramBean, Class<? extends OutputModel> outputClass) throws QSException {
        return new RequestHandler((Map<String, Object>)context, paramBean, outputClass);
    }
}

