/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.rpc.remoting.net.params;

import com.xxl.rpc.remoting.invoker.call.XxlRpcInvokeCallback;
import com.xxl.rpc.remoting.net.params.XxlRpcRequest;
import com.xxl.rpc.remoting.net.params.XxlRpcResponse;
import com.xxl.rpc.util.XxlRpcException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class XxlRpcFutureResponse
implements Future<XxlRpcResponse> {
    private XxlRpcRequest request;
    private XxlRpcResponse response;
    private boolean done = false;
    private Object lock = new Object();
    private XxlRpcInvokeCallback invokeCallback;

    public XxlRpcFutureResponse(XxlRpcRequest request, XxlRpcInvokeCallback invokeCallback) {
        this.request = request;
        this.invokeCallback = invokeCallback;
    }

    public XxlRpcRequest getRequest() {
        return this.request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResponse(XxlRpcResponse response) {
        this.response = response;
        if (this.invokeCallback != null) {
            if (this.response.getErrorMsg() != null) {
                this.invokeCallback.onFailure(new XxlRpcException(this.response.getErrorMsg()));
            } else {
                this.invokeCallback.onSuccess(this.response.getResult());
            }
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            this.done = true;
            this.lock.notifyAll();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public XxlRpcResponse get() throws InterruptedException, ExecutionException {
        try {
            return this.get(-1L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new XxlRpcException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XxlRpcResponse get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.done) {
            Object object = this.lock;
            synchronized (object) {
                if (timeout < 0L) {
                    this.lock.wait();
                } else {
                    long timeoutMillis = TimeUnit.MILLISECONDS == unit ? timeout : TimeUnit.MILLISECONDS.convert(timeout, unit);
                    this.lock.wait(timeoutMillis);
                }
            }
        }
        if (!this.done) {
            throw new XxlRpcException("xxl-rpc, request timeout at:" + System.currentTimeMillis() + ", request:" + this.request.toString());
        }
        return this.response;
    }
}

